/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.version;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.version.AssetIndexInfo;
import org.to2mbn.jmccc.version.DownloadInfo;
import org.to2mbn.jmccc.version.Library;

public class Version
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String version;
    private final String type;
    private final String mainClass;
    private final String assets;
    private final List<String> gameArgs;
    private final List<String> jvmArgs;
    private final String root;
    private final Set<Library> libraries;
    private final boolean legacy;
    private final AssetIndexInfo assetIndexDownloadInfo;
    private final Map<String, DownloadInfo> downloads;

    public Version(String version, String type, String mainClass, String assets, List<String> gameArgs, List<String> jvmArgs, String root, Set<Library> libraries, boolean legacy, AssetIndexInfo assetIndexDownloadInfo, Map<String, DownloadInfo> downloads) {
        this.version = Objects.requireNonNull(version);
        this.type = type;
        this.mainClass = Objects.requireNonNull(mainClass);
        this.assets = Objects.requireNonNull(assets);
        this.gameArgs = Objects.requireNonNull(gameArgs);
        this.jvmArgs = Objects.requireNonNull(jvmArgs);
        this.root = Objects.requireNonNull(root);
        this.libraries = Objects.requireNonNull(libraries);
        this.legacy = legacy;
        this.assetIndexDownloadInfo = assetIndexDownloadInfo;
        this.downloads = Objects.requireNonNull(downloads);
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getAssets() {
        return this.assets;
    }

    public List<String> getGameArgs() {
        return this.gameArgs;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public String getRoot() {
        return this.root;
    }

    public Set<Library> getLibraries() {
        return this.libraries;
    }

    public AssetIndexInfo getAssetIndexDownloadInfo() {
        return this.assetIndexDownloadInfo;
    }

    public Map<String, DownloadInfo> getDownloads() {
        return this.downloads;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public Set<Library> getMissingLibraries(MinecraftDirectory minecraftDir) {
        LinkedHashSet<Library> missing = new LinkedHashSet<Library>();
        for (Library library : this.libraries) {
            if (!library.isMissing(minecraftDir)) continue;
            missing.add(library);
        }
        return Collections.unmodifiableSet(missing);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Version) {
            Version another = (Version)obj;
            return Objects.equals(this.version, another.version) && Objects.equals(this.type, another.type) && Objects.equals(this.mainClass, another.mainClass) && Objects.equals(this.assets, another.assets) && Objects.equals(this.gameArgs, another.gameArgs) && Objects.equals(this.root, another.root) && Objects.equals(this.libraries, another.libraries) && this.legacy == another.legacy && Objects.equals(this.assetIndexDownloadInfo, another.assetIndexDownloadInfo) && Objects.equals(this.downloads, another.downloads);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.libraries);
    }

    public String toString() {
        return this.version;
    }
}

