/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.version;

import java.util.Objects;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.version.Artifact;
import org.to2mbn.jmccc.version.LibraryInfo;

public class Library
extends Artifact {
    private static final long serialVersionUID = 1L;
    private LibraryInfo downloadInfo;
    private String customizedUrl;
    private String[] checksums;

    public Library(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, "jar");
    }

    public Library(String groupId, String artifactId, String version, String classifier, String type) {
        this(groupId, artifactId, version, classifier, type, null);
    }

    public Library(String groupId, String artifactId, String version, String classifier, String type, LibraryInfo downloadInfo) {
        this(groupId, artifactId, version, classifier, type, downloadInfo, null, null);
    }

    public Library(String groupId, String artifactId, String version, String classifier, String type, LibraryInfo downloadInfo, String customizedUrl, String[] checksums) {
        super(groupId, artifactId, version, classifier, type);
        this.downloadInfo = downloadInfo;
        this.customizedUrl = customizedUrl;
        this.checksums = checksums;
    }

    public LibraryInfo getDownloadInfo() {
        return this.downloadInfo;
    }

    public String getCustomizedUrl() {
        return this.customizedUrl;
    }

    public String[] getChecksums() {
        return this.checksums;
    }

    public boolean isMissing(MinecraftDirectory minecraftDir) {
        return !minecraftDir.getLibrary(this).isFile();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Library) {
            Library another = (Library)obj;
            return super.equals(obj) && Objects.equals(this.downloadInfo, another.downloadInfo) && Objects.equals(this.customizedUrl, another.customizedUrl) && Objects.deepEquals(this.checksums, another.checksums);
        }
        return false;
    }
}

