/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.version;

import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.util.ChecksumUtils;

public class Asset
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String virtualPath;
    private String hash;
    private int size;

    public Asset(String virtualPath, String hash, int size) {
        this.virtualPath = Objects.requireNonNull(virtualPath);
        this.hash = Objects.requireNonNull(hash);
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.size = size;
    }

    public String getVirtualPath() {
        return this.virtualPath;
    }

    public String getHash() {
        return this.hash;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return this.virtualPath + " [hash=" + this.hash + ", size=" + this.size + "]";
    }

    public String getPath() {
        return this.hash.substring(0, 2) + "/" + this.hash;
    }

    public boolean isValid(MinecraftDirectory dir) throws IOException, NoSuchAlgorithmException {
        return ChecksumUtils.verify(dir.getAsset(this), this.getHash(), "SHA-1", (long)this.size);
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Asset) {
            Asset another = (Asset)obj;
            return this.virtualPath.equals(another.virtualPath) && this.hash.equals(another.hash) && this.size == another.size;
        }
        return false;
    }
}

