/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.option;

import java.io.Serializable;
import java.util.Objects;

public class ServerInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String host;
    private int port;

    public ServerInfo(String host) {
        this(host, 25565);
    }

    public ServerInfo(String host, int port) {
        Objects.requireNonNull(host);
        if (port < 0) {
            throw new IllegalArgumentException("port<0");
        }
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.host + ':' + this.port;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ServerInfo) {
            ServerInfo another = (ServerInfo)obj;
            return this.port == another.port && this.host.equals(another.host);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }
}

