/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.option;

import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import org.to2mbn.jmccc.util.Platform;

public class JavaEnvironment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File javaPath;

    public JavaEnvironment(File javaPath) {
        Objects.requireNonNull(javaPath);
        this.javaPath = javaPath;
    }

    public static JavaEnvironment current() {
        return new JavaEnvironment(JavaEnvironment.getCurrentJavaPath());
    }

    public static File getCurrentJavaPath() {
        return new File(System.getProperty("java.home"), "bin/java" + (Platform.CURRENT == Platform.WINDOWS ? ".exe" : ""));
    }

    public File getJavaPath() {
        return this.javaPath;
    }

    public String toString() {
        return this.javaPath.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JavaEnvironment) {
            JavaEnvironment another = (JavaEnvironment)obj;
            return this.javaPath.equals(another.javaPath);
        }
        return false;
    }

    public int hashCode() {
        return this.javaPath.hashCode();
    }
}

