/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.liteloader;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.to2mbn.jmccc.internal.org.json.JSONArray;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.mcdownloader.provider.liteloader.LiteloaderVersion;

public class LiteloaderVersionList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Map<String, LiteloaderVersion>> versions;
    private Map<String, LiteloaderVersion> latests;
    private Map<String, LiteloaderVersion> snapshots;

    public LiteloaderVersionList(Map<String, Map<String, LiteloaderVersion>> versions) {
        Objects.requireNonNull(versions);
        this.versions = versions;
        this.latests = Collections.unmodifiableMap(LiteloaderVersionList.filterByArtefactId(versions, "latest"));
        this.snapshots = Collections.unmodifiableMap(LiteloaderVersionList.filterByArtefactId(versions, "snapshot"));
    }

    public static LiteloaderVersionList fromJson(JSONObject json) {
        TreeMap<String, Map<String, LiteloaderVersion>> versions = new TreeMap<String, Map<String, LiteloaderVersion>>();
        JSONObject versionsJson = json.getJSONObject("versions");
        for (String mcversion : versionsJson.keySet()) {
            JSONObject snapshotsJson;
            JSONObject artefactsJson;
            TreeMap<String, LiteloaderVersion> artefacts = new TreeMap<String, LiteloaderVersion>();
            JSONObject versionRootJson = versionsJson.getJSONObject(mcversion);
            String repoUrl = null;
            JSONObject repoJson = versionRootJson.optJSONObject("repo");
            if (repoJson != null) {
                repoUrl = repoJson.optString("url", null);
            }
            if ((artefactsJson = versionRootJson.optJSONObject("artefacts")) != null) {
                JSONObject liteloaderArtefactsJson = artefactsJson.getJSONObject("com.mumfrey:liteloader");
                for (String artefactId : liteloaderArtefactsJson.keySet()) {
                    JSONObject artefactJson = liteloaderArtefactsJson.getJSONObject(artefactId);
                    String liteloaderVersion = artefactJson.getString("version");
                    String tweakClass = artefactJson.optString("tweakClass", null);
                    Set<JSONObject> libraries = LiteloaderVersionList.parseLibraries(artefactJson.optJSONArray("libraries"));
                    artefacts.put(artefactId, new LiteloaderVersion(mcversion, liteloaderVersion, tweakClass, null, Collections.unmodifiableSet(libraries)));
                }
            }
            if ((snapshotsJson = versionRootJson.optJSONObject("snapshots")) != null) {
                Set<JSONObject> libraries = LiteloaderVersionList.parseLibraries(snapshotsJson.optJSONArray("libraries"));
                artefacts.put("snapshot", new LiteloaderVersion(mcversion, mcversion + "-SNAPSHOT", null, repoUrl, Collections.unmodifiableSet(libraries)));
            }
            if (artefacts.isEmpty()) continue;
            versions.put(mcversion, artefacts);
        }
        return new LiteloaderVersionList(versions);
    }

    private static Set<JSONObject> parseLibraries(JSONArray librariesJson) {
        LinkedHashSet<JSONObject> libraries = null;
        if (librariesJson != null) {
            libraries = new LinkedHashSet<JSONObject>();
            for (int i = 0; i < librariesJson.length(); ++i) {
                libraries.add(librariesJson.getJSONObject(i));
            }
        }
        return libraries;
    }

    private static Map<String, LiteloaderVersion> filterByArtefactId(Map<String, Map<String, LiteloaderVersion>> versions, String id) {
        TreeMap<String, LiteloaderVersion> result = new TreeMap<String, LiteloaderVersion>();
        for (Map.Entry<String, Map<String, LiteloaderVersion>> entry : versions.entrySet()) {
            LiteloaderVersion latest = entry.getValue().get(id);
            if (latest == null) continue;
            result.put(entry.getKey(), latest);
        }
        return result;
    }

    public Map<String, Map<String, LiteloaderVersion>> getAllArtefacts() {
        return this.versions;
    }

    public Map<String, LiteloaderVersion> getArtefacts(String minecraftVersion) {
        return this.versions.get(minecraftVersion);
    }

    public LiteloaderVersion getArtefact(String minecraftVersion, String artefactId) {
        Map<String, LiteloaderVersion> artefacts = this.versions.get(minecraftVersion);
        if (artefacts != null) {
            return artefacts.get(artefactId);
        }
        return null;
    }

    public LiteloaderVersion getLatest(String minecraftVersion) {
        return this.getArtefact(minecraftVersion, "latest");
    }

    public LiteloaderVersion getSnapshot(String minecraftVersion) {
        return this.getArtefact(minecraftVersion, "snapshot");
    }

    public Map<String, LiteloaderVersion> getLatests() {
        return this.latests;
    }

    public Map<String, LiteloaderVersion> getSnapshots() {
        return this.snapshots;
    }

    public String toString() {
        return "LiteloaderVersionList [" + this.versions + "]";
    }

    public int hashCode() {
        return this.versions.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LiteloaderVersionList) {
            LiteloaderVersionList another = (LiteloaderVersionList)obj;
            return Objects.equals(this.versions, another.versions) && Objects.equals(this.latests, another.latests) && Objects.equals(this.snapshots, another.snapshots);
        }
        return false;
    }
}

