/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.liteloader;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.to2mbn.jmccc.internal.org.json.JSONObject;

public class LiteloaderVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String minecraftVersion;
    private String liteloaderVersion;
    private String superVersion;
    private String tweakClass;
    private String repoUrl;
    private Set<JSONObject> libraries;

    public LiteloaderVersion(String minecraftVersion, String liteloaderVersion, String tweakClass, String repoUrl, Set<JSONObject> libraries) {
        this(minecraftVersion, liteloaderVersion, minecraftVersion, tweakClass, repoUrl, libraries);
    }

    public LiteloaderVersion(String minecraftVersion, String liteloaderVersion, String superVersion, String tweakClass, String repoUrl, Set<JSONObject> libraries) {
        this.minecraftVersion = Objects.requireNonNull(minecraftVersion);
        this.liteloaderVersion = Objects.requireNonNull(liteloaderVersion);
        this.superVersion = Objects.requireNonNull(superVersion);
        this.tweakClass = tweakClass;
        this.repoUrl = repoUrl;
        this.libraries = libraries;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getLiteloaderVersion() {
        return this.liteloaderVersion;
    }

    public String getSuperVersion() {
        return this.superVersion;
    }

    public String getTweakClass() {
        return this.tweakClass;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public Set<JSONObject> getLibraries() {
        return this.libraries;
    }

    public String getVersionName() {
        return this.superVersion + "-LiteLoader" + this.minecraftVersion;
    }

    public LiteloaderVersion customize(String superVersion) {
        return new LiteloaderVersion(this.minecraftVersion, this.liteloaderVersion, superVersion, this.tweakClass, this.repoUrl, this.libraries);
    }

    public String toString() {
        return this.getVersionName();
    }

    public int hashCode() {
        return Objects.hash(this.minecraftVersion, this.liteloaderVersion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LiteloaderVersion) {
            LiteloaderVersion another = (LiteloaderVersion)obj;
            return Objects.equals(this.minecraftVersion, another.minecraftVersion) && Objects.equals(this.liteloaderVersion, another.liteloaderVersion) && Objects.equals(this.superVersion, another.superVersion) && Objects.equals(this.tweakClass, another.tweakClass) && Objects.equals(this.repoUrl, another.repoUrl) && Objects.equals(this.libraries, another.libraries);
        }
        return false;
    }
}

