/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.forge;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.to2mbn.jmccc.internal.org.json.JSONException;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.FileDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.MemoryDownloadTask;
import org.to2mbn.jmccc.mcdownloader.provider.AbstractMinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.ExtendedDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.JsonDecoder;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.VersionJsonInstaller;
import org.to2mbn.jmccc.mcdownloader.provider.forge.DefaultForgeDownloadSource;
import org.to2mbn.jmccc.mcdownloader.provider.forge.ForgeDownloadSource;
import org.to2mbn.jmccc.mcdownloader.provider.forge.ForgeVersion;
import org.to2mbn.jmccc.mcdownloader.provider.forge.ForgeVersionList;
import org.to2mbn.jmccc.mcdownloader.provider.forge.InstallProfileProcessor;
import org.to2mbn.jmccc.mcdownloader.provider.forge.ResolvedForgeVersion;
import org.to2mbn.jmccc.mcdownloader.provider.forge.UniversalDecompressor;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.util.FileUtils;
import org.to2mbn.jmccc.util.IOUtils;
import org.to2mbn.jmccc.version.Library;
import org.to2mbn.jmccc.version.Version;
import org.to2mbn.jmccc.version.parsing.Versions;

public class ForgeDownloadProvider
extends AbstractMinecraftDownloadProvider
implements ExtendedDownloadProvider {
    public static final String FORGE_GROUP_ID = "net.minecraftforge";
    public static final String FORGE_ARTIFACT_ID = "forge";
    public static final String FORGE_OLD_ARTIFACT_ID = "minecraftforge";
    public static final String CLASSIFIER_INSTALLER = "installer";
    public static final String CLASSIFIER_UNIVERSAL = "universal";
    public static final String MINECRAFT_MAINCLASS = "net.minecraft.client.Minecraft";
    private static final String[] UNIVERSAL_TYPES = new String[]{"jar", "zip"};
    private final ForgeDownloadSource source;
    private MinecraftDownloadProvider upstreamProvider;

    public ForgeDownloadProvider() {
        this(new DefaultForgeDownloadSource());
    }

    public ForgeDownloadProvider(ForgeDownloadSource source) {
        if (source == null) {
            source = new DefaultForgeDownloadSource();
        }
        this.source = source;
    }

    public CombinedDownloadTask<ForgeVersionList> forgeVersionList() {
        return CombinedDownloadTask.all(new MemoryDownloadTask(this.source.getForgeMetadataUrl()).andThen(new JsonDecoder()).cacheable().cachePool("org.to2mbn.jmccc.mcdownloader.cache.dynamic.forge.versionMeta"), new MemoryDownloadTask(this.source.getForgePromotionUrl()).andThen(new JsonDecoder()).cacheable().cachePool("org.to2mbn.jmccc.mcdownloader.cache.dynamic.forge.versionPromo")).andThen(it -> ForgeVersionList.fromJson((JSONObject)it[0], (JSONObject)it[1]));
    }

    @Override
    public CombinedDownloadTask<String> gameVersionJson(MinecraftDirectory mcdir, String version) {
        ResolvedForgeVersion forgeInfo = ResolvedForgeVersion.resolve(version);
        if (forgeInfo != null) {
            return this.forgeVersion(forgeInfo.getForgeVersion()).andThenDownload(forge -> CombinedDownloadTask.any(this.installerTask(forge.getMavenVersion()).andThen(new InstallProfileProcessor(mcdir)), this.upstreamProvider.gameVersionJson(mcdir, forge.getMinecraftVersion()).andThen(superversion -> this.createForgeVersionJson(mcdir, (ForgeVersion)forge)).andThen(new VersionJsonInstaller(mcdir))));
        }
        return null;
    }

    @Override
    public CombinedDownloadTask<Void> library(MinecraftDirectory mcdir, Library library) {
        if (FORGE_GROUP_ID.equals(library.getGroupId())) {
            if (FORGE_ARTIFACT_ID.equals(library.getArtifactId())) {
                return this.universalTask(library.getVersion(), mcdir.getLibrary(library));
            }
            if (FORGE_OLD_ARTIFACT_ID.equals(library.getArtifactId())) {
                return this.forgeVersion(library.getVersion()).andThenDownload(version -> this.universalTask(version.getMavenVersion(), mcdir.getLibrary(library)));
            }
        }
        return null;
    }

    @Override
    public CombinedDownloadTask<Void> gameJar(MinecraftDirectory mcdir, Version version) {
        ResolvedForgeVersion forgeInfo = ResolvedForgeVersion.resolve(version.getRoot());
        if (forgeInfo == null) {
            return null;
        }
        boolean mergeJar = true;
        for (Library library : version.getLibraries()) {
            if (!library.getGroupId().equals(FORGE_GROUP_ID)) continue;
            mergeJar = false;
            break;
        }
        CombinedDownloadTask<Version> baseTask = forgeInfo.getMinecraftVersion() == null ? this.forgeVersion(forgeInfo.getForgeVersion()).andThenDownload(forge -> this.downloadSuperVersion(mcdir, forge.getMinecraftVersion())) : this.downloadSuperVersion(mcdir, forgeInfo.getMinecraftVersion());
        File targetJar = mcdir.getVersionJar(version);
        if (mergeJar) {
            File universalFile = mcdir.getLibrary(new Library(FORGE_GROUP_ID, FORGE_OLD_ARTIFACT_ID, forgeInfo.getForgeVersion()));
            return baseTask.andThenDownload(superVersion -> this.forgeVersion(forgeInfo.getForgeVersion()).andThenDownload(forge -> this.universalTask(forge.getMavenVersion(), universalFile).andThenReturn(superVersion))).andThen(superVersion -> {
                this.mergeJar(mcdir.getVersionJar((Version)superVersion), universalFile, targetJar);
                return null;
            });
        }
        return baseTask.andThen(superVersion -> {
            this.purgeMetaInf(mcdir.getVersionJar((Version)superVersion), targetJar);
            return null;
        });
    }

    @Override
    public void setUpstreamProvider(MinecraftDownloadProvider upstreamProvider) {
        this.upstreamProvider = upstreamProvider;
    }

    protected CombinedDownloadTask<byte[]> installerTask(String m2Version) {
        Library lib = new Library(FORGE_GROUP_ID, FORGE_ARTIFACT_ID, m2Version, CLASSIFIER_INSTALLER, "jar");
        return CombinedDownloadTask.single(new MemoryDownloadTask(this.source.getForgeMavenRepositoryUrl() + lib.getPath()).cacheable().cachePool("org.to2mbn.jmccc.mcdownloader.cache.static.forge.installer"));
    }

    protected CombinedDownloadTask<Void> universalTask(String m2Version, File target) {
        String[] types = UNIVERSAL_TYPES;
        CombinedDownloadTask[] tasks = new CombinedDownloadTask[types.length + 1];
        tasks[0] = this.installerTask(m2Version).andThen(new UniversalDecompressor(target, m2Version));
        for (int i = 0; i < types.length; ++i) {
            Library lib = new Library(FORGE_GROUP_ID, FORGE_ARTIFACT_ID, m2Version, CLASSIFIER_UNIVERSAL, types[i]);
            tasks[i + 1] = CombinedDownloadTask.single(new FileDownloadTask(this.source.getForgeMavenRepositoryUrl() + lib.getPath(), target).cachePool("org.to2mbn.jmccc.mcdownloader.cache.static.forge.universal"));
        }
        return CombinedDownloadTask.any(tasks);
    }

    protected JSONObject createForgeVersionJson(MinecraftDirectory mcdir, ForgeVersion forgeVersion) throws IOException, JSONException {
        JSONObject versionjson = IOUtils.toJson(mcdir.getVersionJson(forgeVersion.getMinecraftVersion()));
        versionjson.remove("downloads");
        versionjson.remove("assets");
        versionjson.remove("assetIndex");
        versionjson.put("id", forgeVersion.getVersionName());
        versionjson.put("mainClass", MINECRAFT_MAINCLASS);
        return versionjson;
    }

    protected void mergeJar(File parent, File universal, File target) throws IOException {
        FileUtils.prepareWrite(target);
        try (ZipInputStream in = new ZipInputStream(Files.newInputStream(parent.toPath(), new OpenOption[0]));
             ZipInputStream universalIn = new ZipInputStream(Files.newInputStream(universal.toPath(), new OpenOption[0]));
             ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(target.toPath(), new OpenOption[0]));){
            int read;
            ZipEntry entry;
            byte[] buf = new byte[8192];
            HashSet<String> universalEntries = new HashSet<String>();
            while ((entry = universalIn.getNextEntry()) != null) {
                universalEntries.add(entry.getName());
                out.putNextEntry(entry);
                while ((read = universalIn.read(buf)) != -1) {
                    out.write(buf, 0, read);
                }
                out.closeEntry();
                universalIn.closeEntry();
            }
            while ((entry = in.getNextEntry()) != null) {
                if (this.isNotMetaInfEntry(entry) && !universalEntries.contains(entry.getName())) {
                    out.putNextEntry(entry);
                    while ((read = in.read(buf)) != -1) {
                        out.write(buf, 0, read);
                    }
                    out.closeEntry();
                }
                in.closeEntry();
            }
        }
    }

    protected void purgeMetaInf(File src, File target) throws IOException {
        FileUtils.prepareWrite(target);
        try (ZipInputStream in = new ZipInputStream(Files.newInputStream(src.toPath(), new OpenOption[0]));
             ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(target.toPath(), new OpenOption[0]));){
            ZipEntry entry;
            byte[] buf = new byte[8192];
            while ((entry = in.getNextEntry()) != null) {
                if (this.isNotMetaInfEntry(entry)) {
                    int read;
                    out.putNextEntry(entry);
                    while ((read = in.read(buf)) != -1) {
                        out.write(buf, 0, read);
                    }
                    out.closeEntry();
                }
                in.closeEntry();
            }
        }
    }

    private CombinedDownloadTask<ForgeVersion> forgeVersion(String forgeVersion) {
        return this.forgeVersionList().andThen(versionList -> {
            ForgeVersion forge = versionList.get(forgeVersion);
            if (forge == null) {
                throw new IllegalArgumentException("Forge version not found: " + forgeVersion);
            }
            return forge;
        });
    }

    private boolean isNotMetaInfEntry(ZipEntry entry) {
        return !entry.getName().startsWith("META-INF/");
    }

    private CombinedDownloadTask<Version> downloadSuperVersion(MinecraftDirectory mcdir, String version) {
        return this.upstreamProvider.gameVersionJson(mcdir, version).andThenDownload(resolvedMcversion -> {
            Version superversion = Versions.resolveVersion(mcdir, resolvedMcversion);
            return this.upstreamProvider.gameJar(mcdir, superversion).andThenReturn(superversion);
        });
    }
}

