/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.fabric;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FabricVersion {
    private final String minecraftVersion;
    private final String fabricLoaderVersion;
    private final String loaderName;
    private static final Pattern PATTERN = Pattern.compile("^([\\w.\\-]+)-loader-([\\w.\\-]+)-([\\w.\\-]+)$");

    public FabricVersion(String minecraftVersion, String fabricLoaderVersion, String loaderName) {
        this.minecraftVersion = minecraftVersion;
        this.fabricLoaderVersion = fabricLoaderVersion;
        this.loaderName = loaderName;
    }

    public static FabricVersion resolve(String loaderName, String version) {
        Matcher m = PATTERN.matcher(version);
        if (m.matches()) {
            if (!loaderName.equals(m.group(1))) {
                return null;
            }
            return new FabricVersion(m.group(3), m.group(2), m.group(1));
        }
        return null;
    }

    public String getVersionName() {
        return this.loaderName + "-loader-" + this.fabricLoaderVersion + "-" + this.minecraftVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getFabricLoaderVersion() {
        return this.fabricLoaderVersion;
    }
}

