/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.MemoryDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.ResultProcessor;
import org.to2mbn.jmccc.mcdownloader.provider.LibraryDownloadHandler;
import org.to2mbn.jmccc.mcdownloader.provider.PackProcessor;
import org.to2mbn.jmccc.version.Library;
import org.tukaani.xz.XZInputStream;

class XZPackLibraryDownloadHandler
implements LibraryDownloadHandler {
    XZPackLibraryDownloadHandler() {
    }

    @Override
    public DownloadTask<Void> createDownloadTask(File target, Library library, URI libraryUri) {
        return new MemoryDownloadTask(libraryUri).andThen(new ResultProcessor<byte[], byte[]>(){

            @Override
            public byte[] process(byte[] data) throws IOException {
                try (XZInputStream in = new XZInputStream(new ByteArrayInputStream(data));){
                    byte[] byArray;
                    try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                        int read;
                        byte[] buffer = new byte[8192];
                        while ((read = in.read(buffer)) != -1) {
                            out.write(buffer, 0, read);
                        }
                        byArray = out.toByteArray();
                    }
                    return byArray;
                }
            }
        }).andThen(new PackProcessor(target));
    }
}

