/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.tasks;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.to2mbn.jmccc.mcdownloader.download.tasks.AndThenDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadSession;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadTaskCachePoolDecorator;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadTaskCacheableDecorator;
import org.to2mbn.jmccc.mcdownloader.download.tasks.ResultProcessor;

public abstract class DownloadTask<T> {
    private URI uri;

    public DownloadTask(String uri) {
        this(URI.create(uri));
    }

    public DownloadTask(URI uri) {
        this.uri = uri;
    }

    public final URI getURI() {
        return this.uri;
    }

    public boolean isCacheable() {
        return false;
    }

    public String getCachePool() {
        return null;
    }

    public abstract DownloadSession<T> createSession() throws IOException;

    public DownloadSession<T> createSession(long length) throws IOException {
        return this.createSession();
    }

    public final <R> DownloadTask<R> andThen(ResultProcessor<T, R> processor) {
        Objects.requireNonNull(processor);
        return new AndThenDownloadTask<T, R>(processor, this);
    }

    public final DownloadTask<T> cacheable() {
        return this.cacheable(true);
    }

    public final DownloadTask<T> cacheable(boolean cacheable) {
        if (this.isCacheable() == cacheable) {
            return this;
        }
        return new DownloadTaskCacheableDecorator(this, cacheable);
    }

    public final DownloadTask<T> cachePool(String pool) {
        if (Objects.equals(this.getCachePool(), pool)) {
            return this;
        }
        return new DownloadTaskCachePoolDecorator(this, pool);
    }
}

