/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.to2mbn.jmccc.mcdownloader.download.Downloader;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Callback;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.CallbackFutureTask;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Callbacks;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.DownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.DownloadCallbacks;
import org.to2mbn.jmccc.mcdownloader.download.io.DownloaderHelper;
import org.to2mbn.jmccc.mcdownloader.download.io.GzipDownloadSession;
import org.to2mbn.jmccc.mcdownloader.download.io.IllegalHttpResponseCodeException;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadSession;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadTask;
import org.to2mbn.jmccc.mcdownloader.util.ThreadPoolUtils;

class JdkHttpDownloader
implements Downloader {
    private static final int BUFFER_SIZE = 8192;
    private static final Logger LOGGER = Logger.getLogger(JdkHttpDownloader.class.getCanonicalName());
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final Set<Future<?>> tasks = Collections.newSetFromMap(new ConcurrentHashMap());
    private ExecutorService executor;
    private int connectTimeout;
    private int readTimeout;
    private Proxy proxy;
    private volatile boolean shutdown;

    public JdkHttpDownloader(int maxConns, int connectTimeout, int readTimeout, long poolThreadLivingTime, TimeUnit poolThreadLivingTimeUnit, Proxy proxy) {
        Objects.requireNonNull(proxy);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.proxy = proxy;
        this.executor = ThreadPoolUtils.createPool(maxConns, poolThreadLivingTime, poolThreadLivingTimeUnit, "jdkDownloader.io");
    }

    @Override
    public <T> Future<T> download(DownloadTask<T> task, DownloadCallback<T> callback) {
        return this.download(task, callback, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> download(DownloadTask<T> downloadTask, DownloadCallback<T> callback, int tries) {
        Objects.requireNonNull(downloadTask);
        if (tries < 1) {
            throw new IllegalArgumentException("tries < 1");
        }
        CallbackFutureTask<T> task = new CallbackFutureTask<T>(new CallableDownloadTask<T>(downloadTask, callback == null ? DownloadCallbacks.empty() : callback, tries));
        Callback statusCallback = Callbacks.whatever(new TaskInactiver(task));
        if (callback != null) {
            statusCallback = Callbacks.group(statusCallback, callback);
        }
        task.setCallback(callback);
        Lock lock = this.rwlock.readLock();
        lock.lock();
        try {
            if (this.shutdown) {
                throw new RejectedExecutionException("The downloader has been shutdown.");
            }
            this.tasks.add(task);
            this.executor.execute(task);
        }
        finally {
            lock.unlock();
        }
        return task;
    }

    @Override
    public void shutdown() {
        Lock lock = this.rwlock.writeLock();
        lock.lock();
        try {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        finally {
            lock.unlock();
        }
        for (Future<?> task : this.tasks) {
            task.cancel(true);
        }
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    private class CallableDownloadTask<T>
    implements Callable<T> {
        private final DownloadTask<T> task;
        private final DownloadCallback<T> callback;
        private final int maxTries;
        private boolean skipRetry = false;

        public CallableDownloadTask(DownloadTask<T> task, DownloadCallback<T> callback, int maxTries) {
            Objects.requireNonNull(task);
            Objects.requireNonNull(callback);
            if (maxTries < 1) {
                throw new IllegalArgumentException(String.valueOf(maxTries));
            }
            this.task = task;
            this.callback = callback;
            this.maxTries = maxTries;
        }

        @Override
        public T call() throws Exception {
            int currentTries = 0;
            while (true) {
                try {
                    return this.download();
                }
                catch (IOException e) {
                    this.checkInterrupted();
                    if (++currentTries < this.maxTries && !this.skipRetry && DownloaderHelper.shouldRetry(e)) {
                        this.callback.retry(e, currentTries, this.maxTries);
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }

        private T download() throws Exception {
            return this.downloadCore(this.task.getURI().toURL());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T downloadCore(URL url) throws Exception {
            URLConnection connection = url.openConnection(JdkHttpDownloader.this.proxy);
            connection.setReadTimeout(JdkHttpDownloader.this.readTimeout);
            connection.setConnectTimeout(JdkHttpDownloader.this.connectTimeout);
            connection.setRequestProperty("Accept", "*/*");
            connection.setRequestProperty("Connection", "keep-alive");
            connection.setRequestProperty("Accept-Encoding", "gzip");
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("GET");
                ((HttpURLConnection)connection).setInstanceFollowRedirects(true);
            }
            connection.connect();
            try {
                DownloadSession<T> session;
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection urlConnection = (HttpURLConnection)connection;
                    int responseCode = urlConnection.getResponseCode();
                    if (responseCode == 301 || responseCode == 302 || responseCode == 307) {
                        T t = this.downloadCore(new URL(urlConnection.getHeaderField("Location")));
                        return t;
                    }
                    if (responseCode < 200 || responseCode > 299) {
                        throw new IllegalHttpResponseCodeException(urlConnection.getHeaderField(0), responseCode);
                    }
                }
                String contentLengthStr = connection.getHeaderField("Content-Length");
                long contentLength = -1L;
                if (contentLengthStr != null) {
                    try {
                        contentLength = Long.parseLong(contentLengthStr);
                        if (contentLength < 0L) {
                            LOGGER.warning("Invalid Content-Length: " + contentLengthStr + ", ignoring");
                            contentLength = -1L;
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warning("Invalid Content-Length: " + contentLengthStr + ", ignoring: " + e);
                    }
                }
                this.checkInterrupted();
                DownloadSession<T> downloadSession = session = contentLength == -1L ? this.task.createSession() : this.task.createSession(contentLength);
                if (connection instanceof HttpURLConnection && "gzip".equals(connection.getHeaderField("Content-Encoding"))) {
                    session = new GzipDownloadSession<T>(session);
                }
                long downloaded = 0L;
                try (InputStream in = connection.getInputStream();){
                    int read;
                    byte[] buf = new byte[8192];
                    while ((read = in.read(buf)) != -1) {
                        this.checkInterrupted();
                        session.receiveData(ByteBuffer.wrap(buf, 0, read));
                        this.skipRetry = true;
                        this.callback.updateProgress(downloaded += (long)read, contentLength);
                        this.skipRetry = false;
                    }
                }
                catch (Throwable e) {
                    session.failed();
                    throw e;
                }
                T t = session.completed();
                return t;
            }
            finally {
                if (connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).disconnect();
                }
            }
        }

        private void checkInterrupted() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
    }

    private class TaskInactiver
    implements Runnable {
        private final Future<?> future;

        public TaskInactiver(Future<?> future) {
            Objects.requireNonNull(future);
            this.future = future;
        }

        @Override
        public void run() {
            JdkHttpDownloader.this.tasks.remove(this.future);
        }
    }
}

