/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadSession;

public class GzipDownloadSession<T>
implements DownloadSession<T> {
    private final DownloadSession<T> underlying;
    private ByteArrayOutputStream out;
    private WritableByteChannel channel;

    public GzipDownloadSession(DownloadSession<T> underlying) {
        Objects.requireNonNull(underlying);
        this.underlying = underlying;
        this.out = new ByteArrayOutputStream();
        this.channel = Channels.newChannel(this.out);
    }

    @Override
    public void receiveData(ByteBuffer data) throws IOException {
        this.channel.write(data);
    }

    @Override
    public void failed() throws Exception {
        this.close();
        this.underlying.failed();
    }

    @Override
    public T completed() throws Exception {
        try (GZIPInputStream gzin = new GZIPInputStream(new ByteArrayInputStream(this.out.toByteArray()));){
            int read;
            byte[] buf = new byte[8192];
            ByteBuffer bb = ByteBuffer.wrap(buf);
            while ((read = gzin.read(buf)) != -1) {
                ((Buffer)bb).position(0);
                ((Buffer)bb).limit(read);
                this.underlying.receiveData(bb);
            }
        }
        catch (Throwable e) {
            this.underlying.failed();
            throw e;
        }
        finally {
            this.close();
        }
        return this.underlying.completed();
    }

    private void close() {
        this.channel = null;
        this.out = null;
    }
}

