/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.io;

import java.io.IOException;
import org.to2mbn.jmccc.mcdownloader.download.io.IllegalHttpResponseCodeException;

public final class DownloaderHelper {
    private DownloaderHelper() {
    }

    public static boolean shouldRetry(Throwable e) {
        if (!(e instanceof IOException)) {
            return false;
        }
        if (e instanceof IllegalHttpResponseCodeException) {
            return DownloaderHelper.isResponseCodeRetryable(((IllegalHttpResponseCodeException)e).getResponseCode());
        }
        return true;
    }

    public static boolean isResponseCodeRetryable(int responseCode) {
        if (responseCode >= 400 && responseCode <= 499) {
            return responseCode == 408;
        }
        if (responseCode >= 500 && responseCode <= 599) {
            return responseCode != 500 && responseCode != 505 && responseCode != 506;
        }
        return false;
    }
}

