/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.concurrent;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.AsyncFuture;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Callback;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Cancelable;

public abstract class CallbackAsyncTask<V>
implements RunnableFuture<V>,
Cancelable {
    private final Set<Object> cancelables = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AsyncFuture<V> future;
    private final Callback<V> lifecycle;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public CallbackAsyncTask() {
        this.future = new AsyncFuture(new CancelProcesser());
        this.lifecycle = new InterruptedExceptionMapper<V>(this.future);
    }

    private static void cancelCancelable(Object cancelable, boolean mayInterruptIfRunning) {
        if (cancelable instanceof Future) {
            ((Future)cancelable).cancel(mayInterruptIfRunning);
        } else if (cancelable instanceof Cancelable) {
            ((Cancelable)cancelable).cancel(mayInterruptIfRunning);
        }
    }

    public Callback<V> getCallback() {
        return this.future.getCallback();
    }

    public void setCallback(Callback<V> callback) {
        this.future.setCallback(callback);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    public boolean isExceptional() {
        return this.future.isExceptional();
    }

    @Override
    public void run() {
        if (!this.future.isCancelled() && this.running.compareAndSet(false, true)) {
            ThreadCancelableAdapter canceller = new ThreadCancelableAdapter(Thread.currentThread());
            this.addCancelable(canceller);
            try {
                if (Thread.interrupted()) {
                    return;
                }
                try {
                    this.execute();
                }
                catch (Throwable e) {
                    this.lifecycle.failed(e);
                }
            }
            finally {
                this.removeCancelable(canceller);
            }
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    protected abstract void execute() throws Exception;

    protected Callback<V> lifecycle() {
        return this.lifecycle;
    }

    protected void addCancelable(Cancelable cancelable) {
        this.cancelables.add(cancelable);
        this.cancelIfNecessary(cancelable);
    }

    protected void addCancelable(Future<?> cancelable) {
        this.cancelables.add(cancelable);
        this.cancelIfNecessary(cancelable);
    }

    protected void removeCancelable(Cancelable cancelable) {
        this.cancelables.remove(cancelable);
    }

    protected void removeCancelable(Future<?> cancelable) {
        this.cancelables.remove(cancelable);
    }

    protected <R> FutureManager<R> createFutureManager() {
        return new FutureManagerImpl();
    }

    private void cancelIfNecessary(Object cancelable) {
        if (this.future.isCancelled()) {
            CallbackAsyncTask.cancelCancelable(cancelable, true);
            this.cancelables.remove(cancelable);
        }
    }

    private class CancelProcesser
    implements Cancelable {
        private CancelProcesser() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            for (Object cancelable : CallbackAsyncTask.this.cancelables) {
                CallbackAsyncTask.cancelCancelable(cancelable, mayInterruptIfRunning);
                CallbackAsyncTask.this.cancelables.remove(cancelable);
            }
            return true;
        }
    }

    private static class InterruptedExceptionMapper<V>
    implements Callback<V> {
        private final Callback<V> mapped;

        public InterruptedExceptionMapper(Callback<V> mapped) {
            this.mapped = mapped;
        }

        @Override
        public void done(V result) {
            this.mapped.done(result);
        }

        @Override
        public void failed(Throwable e) {
            if (e instanceof InterruptedException) {
                this.mapped.cancelled();
            } else {
                this.mapped.failed(e);
            }
        }

        @Override
        public void cancelled() {
            this.mapped.cancelled();
        }
    }

    private static class ThreadCancelableAdapter
    implements Cancelable {
        private final Thread t;

        public ThreadCancelableAdapter(Thread t) {
            this.t = t;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.t.interrupt();
            return true;
        }
    }

    private class FutureManagerImpl<R>
    implements FutureManager<R> {
        private final Object lock = new Object();
        private volatile Future<?> subfuture;
        private volatile boolean terminated = false;

        private FutureManagerImpl() {
        }

        @Override
        public void done(R result) {
            this.removeFuture();
        }

        @Override
        public void failed(Throwable e) {
            this.removeFuture();
        }

        @Override
        public void cancelled() {
            this.removeFuture();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFuture(Future<?> subfuture) {
            Objects.requireNonNull(subfuture);
            Object object = this.lock;
            synchronized (object) {
                if (!this.terminated) {
                    this.subfuture = subfuture;
                    CallbackAsyncTask.this.addCancelable(subfuture);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFuture() {
            Object object = this.lock;
            synchronized (object) {
                this.terminated = true;
                if (this.subfuture != null) {
                    CallbackAsyncTask.this.removeCancelable(this.subfuture);
                    this.subfuture = null;
                }
            }
        }
    }

    public static interface FutureManager<T>
    extends Callback<T> {
        public void setFuture(Future<?> var1);
    }
}

