/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.cache.provider;

import java.io.IOException;
import java.util.Objects;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.to2mbn.jmccc.mcdownloader.download.cache.provider.CacheProvider;

public class EhcacheProvider<K, V>
implements CacheProvider<K, V> {
    private CacheManager manager;
    private Class<K> keyClass;
    private Class<V> valueClass;
    private boolean closeCache;

    public EhcacheProvider(CacheManager manager, Class<K> keyClass, Class<V> valueClass, boolean closeCache) {
        this.manager = Objects.requireNonNull(manager);
        this.keyClass = Objects.requireNonNull(keyClass);
        this.valueClass = Objects.requireNonNull(valueClass);
        this.closeCache = closeCache;
    }

    public static boolean isAvailable() {
        try {
            Class.forName("org.ehcache.config.builders.CacheManagerBuilder");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public V get(String cachePool, K key) {
        return this.getCache(cachePool).get(key);
    }

    @Override
    public void put(String cachePool, K key, V value) {
        this.getCache(cachePool).put(key, value);
    }

    @Override
    public void remove(String cachePool, K key) {
        this.getCache(cachePool).remove(key);
    }

    @Override
    public boolean hasCache(String cachePool) {
        return this.manager.getCache(cachePool, this.keyClass, this.valueClass) != null;
    }

    private Cache<K, V> getCache(String pool) {
        Cache<K, V> cache = this.manager.getCache(pool, this.keyClass, this.valueClass);
        if (cache == null) {
            throw new IllegalStateException("Default cache pool [" + pool + "] is not configured.");
        }
        return cache;
    }

    @Override
    public void close() throws IOException {
        if (this.closeCache) {
            this.manager.close();
        }
    }

    public String toString() {
        return String.format("EhcacheProvider [manager=%s, keyClass=%s, valueClass=%s, closeCache=%s]", this.manager, this.keyClass, this.valueClass, this.closeCache);
    }
}

