/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.to2mbn.jmccc.internal.org.json.JSONArray;
import org.to2mbn.jmccc.internal.org.json.JSONException;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.mcdownloader.RemoteVersion;

public class RemoteVersionList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String latestSnapshot;
    private String latestRelease;
    private Map<String, RemoteVersion> versions;

    public RemoteVersionList(String latestSnapshot, String latestRelease, Map<String, RemoteVersion> versions) {
        this.latestSnapshot = latestSnapshot;
        this.latestRelease = latestRelease;
        this.versions = Objects.requireNonNull(versions);
    }

    public static RemoteVersionList fromJson(JSONObject json) throws JSONException {
        String latestSnapshot = null;
        String latestRelease = null;
        if (json.has("latest")) {
            JSONObject latest = json.getJSONObject("latest");
            latestSnapshot = latest.optString("snapshot", null);
            latestRelease = latest.optString("release", null);
        }
        JSONArray jsonVersions = json.getJSONArray("versions");
        LinkedHashMap<String, RemoteVersion> versions = new LinkedHashMap<String, RemoteVersion>();
        for (int i = 0; i < jsonVersions.length(); ++i) {
            RemoteVersion version = RemoteVersion.fromJson(jsonVersions.getJSONObject(i));
            versions.put(version.getVersion(), version);
        }
        return new RemoteVersionList(latestSnapshot, latestRelease, Collections.unmodifiableMap(versions));
    }

    public String getLatestSnapshot() {
        return this.latestSnapshot;
    }

    public String getLatestRelease() {
        return this.latestRelease;
    }

    public Map<String, RemoteVersion> getVersions() {
        return this.versions;
    }

    public String toString() {
        return "[latestSnapshot=" + this.latestSnapshot + ", latestRelease=" + this.latestRelease + ", versions=" + this.versions + "]";
    }

    public int hashCode() {
        return this.versions.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RemoteVersionList) {
            RemoteVersionList another = (RemoteVersionList)obj;
            return Objects.equals(this.versions, another.versions) && Objects.equals(this.latestRelease, another.latestRelease) && Objects.equals(this.latestSnapshot, another.latestSnapshot);
        }
        return false;
    }
}

