/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader;

import java.util.Objects;
import java.util.concurrent.Future;
import org.to2mbn.jmccc.mcdownloader.AssetOption;
import org.to2mbn.jmccc.mcdownloader.CacheOption;
import org.to2mbn.jmccc.mcdownloader.ChecksumOption;
import org.to2mbn.jmccc.mcdownloader.IncrementallyDownloadTask;
import org.to2mbn.jmccc.mcdownloader.MavenOption;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloadOption;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloader;
import org.to2mbn.jmccc.mcdownloader.RemoteVersionList;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloader;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.CombinedDownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.DownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadTask;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.version.Version;

class MinecraftDownloaderImpl
implements MinecraftDownloader {
    private CombinedDownloader combinedDownloader;
    private MinecraftDownloadProvider downloadProvider;

    public MinecraftDownloaderImpl(CombinedDownloader combinedDownloader, MinecraftDownloadProvider downloadProvider) {
        this.combinedDownloader = Objects.requireNonNull(combinedDownloader);
        this.downloadProvider = Objects.requireNonNull(downloadProvider);
    }

    @Override
    public void shutdown() {
        this.combinedDownloader.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.combinedDownloader.isShutdown();
    }

    @Override
    public <T> Future<T> download(DownloadTask<T> task, DownloadCallback<T> callback) {
        return this.combinedDownloader.download(task, callback);
    }

    @Override
    public <T> Future<T> download(CombinedDownloadTask<T> task, CombinedDownloadCallback<T> callback) {
        return this.combinedDownloader.download(task, callback);
    }

    @Override
    public <T> Future<T> download(DownloadTask<T> task, DownloadCallback<T> callback, int tries) {
        return this.combinedDownloader.download(task, callback, tries);
    }

    @Override
    public <T> Future<T> download(CombinedDownloadTask<T> task, CombinedDownloadCallback<T> callback, int tries) {
        return this.combinedDownloader.download(task, callback, tries);
    }

    @Override
    public Future<Version> downloadIncrementally(MinecraftDirectory dir, String version, CombinedDownloadCallback<Version> callback, MinecraftDownloadOption ... options) {
        boolean checkLibrariesHash = false;
        boolean checkAssetsHash = false;
        boolean updateSnapshots = false;
        AssetOption assetOption = null;
        CacheOption cacheOption = null;
        block7: for (MinecraftDownloadOption option : options) {
            if (option instanceof CacheOption) {
                cacheOption = (CacheOption)option;
                continue;
            }
            if (option instanceof AssetOption) {
                assetOption = (AssetOption)option;
                continue;
            }
            if (option instanceof MavenOption) {
                switch ((MavenOption)option) {
                    case UPDATE_SNAPSHOTS: {
                        updateSnapshots = true;
                        break;
                    }
                }
                continue;
            }
            if (!(option instanceof ChecksumOption)) continue;
            switch ((ChecksumOption)option) {
                case CHECK_ASSETS: {
                    checkAssetsHash = true;
                    continue block7;
                }
                case CHECK_LIBRARIES: {
                    checkLibrariesHash = true;
                    continue block7;
                }
            }
        }
        CombinedDownloadTask task = new IncrementallyDownloadTask(this.downloadProvider, dir, version, checkLibrariesHash, checkAssetsHash, updateSnapshots, assetOption);
        if (cacheOption != null) {
            task = this.processCacheOption(task, cacheOption);
        }
        return this.download(task, callback);
    }

    @Override
    public Future<RemoteVersionList> fetchRemoteVersionList(CombinedDownloadCallback<RemoteVersionList> callback, CacheOption ... options) {
        CombinedDownloadTask<RemoteVersionList> task = this.downloadProvider.versionList();
        if (options.length != 0) {
            task = this.processCacheOption(task, options[options.length - 1]);
        }
        return this.download(task, callback);
    }

    @Override
    public MinecraftDownloadProvider getProvider() {
        return this.downloadProvider;
    }

    public String toString() {
        return String.format("MinecraftDownloaderImpl [combinedDownloader=%s, downloadProvider=%s]", this.combinedDownloader, this.downloadProvider);
    }

    private <T> CombinedDownloadTask<T> processCacheOption(CombinedDownloadTask<T> task, CacheOption option) {
        switch (option) {
            case CACHE: {
                return task.cacheable(CombinedDownloadTask.CacheStrategy.CACHEABLE);
            }
            case FORCIBLY_CACHE: {
                return task.cacheable(CombinedDownloadTask.CacheStrategy.FORCIBLY_CACHE);
            }
            case NO_CACHE: {
                return task.cacheable(CombinedDownloadTask.CacheStrategy.NON_CACHEABLE);
            }
        }
        return task;
    }
}

