/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.to2mbn.jmccc.option.LaunchOption;
import org.to2mbn.jmccc.util.Platform;
import org.to2mbn.jmccc.version.Version;

public class LaunchArgument {
    private final LaunchOption launchOption;
    private final File nativesPath;
    private final Set<File> libraries;
    private final Map<String, String> defaultVariables;

    public LaunchArgument(LaunchOption launchOption, Map<String, String> defaultVariables, Set<File> libraries, File nativesPath) {
        this.launchOption = launchOption;
        this.libraries = libraries;
        this.nativesPath = nativesPath;
        this.defaultVariables = defaultVariables;
    }

    public List<String> getJvmArguments() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.launchOption.getMinMemory() != 0) {
            args.add("-Xms" + this.launchOption.getMinMemory() + "M");
        }
        if (this.launchOption.getMaxMemory() != 0) {
            args.add("-Xmx" + this.launchOption.getMaxMemory() + "M");
        }
        for (String string : this.launchOption.extraJvmArguments()) {
            if (string == null) continue;
            args.add(string);
        }
        StringBuilder cpBuilder = new StringBuilder();
        for (File lib : this.libraries) {
            if (lib == null) continue;
            cpBuilder.append(lib.getAbsolutePath()).append(Platform.getPathSeparator());
        }
        if (cpBuilder.length() > 0) {
            cpBuilder.deleteCharAt(cpBuilder.length() - 1);
        }
        this.defaultVariables.put("classpath", cpBuilder.toString());
        List<String> list = this.launchOption.getVersion().getJvmArgs();
        if (list.isEmpty()) {
            list.addAll(Arrays.asList("-Djava.library.path=${natives_directory}", "-cp", "${classpath}"));
        }
        args.addAll(this.getFormattedMinecraftArguments(list));
        return args;
    }

    public List<String> getGameArguments() {
        ArrayList<String> args = new ArrayList<String>(this.getFormattedMinecraftArguments(this.launchOption.getVersion().getGameArgs()));
        for (String arg : this.launchOption.extraMinecraftArguments()) {
            if (arg == null) continue;
            args.add(arg);
        }
        if (this.launchOption.getServerInfo() != null && this.launchOption.getServerInfo().getHost() != null && !this.launchOption.getServerInfo().getHost().equals("")) {
            args.add("--server");
            args.add(this.launchOption.getServerInfo().getHost());
            if (this.launchOption.getServerInfo().getPort() > 0) {
                args.add("--port");
                args.add(String.valueOf(this.launchOption.getServerInfo().getPort()));
            }
        }
        if (this.launchOption.getWindowSize() != null) {
            if (this.launchOption.getWindowSize().isFullScreen()) {
                args.add("--fullscreen");
            } else {
                if (this.launchOption.getWindowSize().getHeight() != 0) {
                    args.add("--height");
                    args.add(String.valueOf(this.launchOption.getWindowSize().getHeight()));
                }
                if (this.launchOption.getWindowSize().getWidth() != 0) {
                    args.add("--width");
                    args.add(String.valueOf(this.launchOption.getWindowSize().getWidth()));
                }
            }
        }
        return args;
    }

    public String[] generateCommandline() {
        ArrayList<String> args = new ArrayList<String>();
        Version version = this.launchOption.getVersion();
        args.add(this.launchOption.getJavaEnvironment().getJavaPath().getAbsolutePath());
        args.addAll(this.getJvmArguments());
        args.add(version.getMainClass());
        args.addAll(this.getGameArguments());
        return args.toArray(new String[0]);
    }

    private List<String> getFormattedMinecraftArguments(List<String> templete) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.putAll(this.defaultVariables);
        variables.putAll(this.launchOption.commandlineVariables());
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : templete) {
            for (Map.Entry var : variables.entrySet()) {
                String k = (String)var.getKey();
                String v = (String)var.getValue();
                if (k == null || v == null) continue;
                arg = arg.replace("${" + k + "}", v);
            }
            args.add(arg);
        }
        return args;
    }

    public LaunchOption getLaunchOption() {
        return this.launchOption;
    }

    public File getNativesPath() {
        return this.nativesPath;
    }

    public Set<File> getLibraries() {
        return this.libraries;
    }

    public Map<String, String> getTokens() {
        return this.defaultVariables;
    }
}

