/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.auth;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.to2mbn.jmccc.auth.AuthInfo;
import org.to2mbn.jmccc.auth.AuthenticationException;
import org.to2mbn.jmccc.auth.Authenticator;
import org.to2mbn.jmccc.util.UUIDUtils;

public class OfflineAuthenticator
implements Authenticator,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String playerName;

    public OfflineAuthenticator(String playerName) {
        Objects.requireNonNull(playerName);
        this.playerName = playerName;
        if (this.playerName.length() == 0) {
            throw new IllegalArgumentException("Player name cannot be empty");
        }
    }

    @Override
    public AuthInfo auth() throws AuthenticationException {
        try {
            return new AuthInfo(this.playerName, UUIDUtils.randomUnsignedUUID(), this.getPlayerUUID(), Collections.unmodifiableMap(new HashMap()), "mojang");
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationException("UTF-8 is not supported", e);
        }
    }

    private UUID getPlayerUUID() throws UnsupportedEncodingException {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.playerName).getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return "OfflineAuthenticator[" + this.playerName + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OfflineAuthenticator) {
            OfflineAuthenticator another = (OfflineAuthenticator)obj;
            return this.playerName.equals(another.playerName);
        }
        return false;
    }

    public int hashCode() {
        return this.playerName.hashCode();
    }

    public static OfflineAuthenticator name(String playerName) {
        return new OfflineAuthenticator(playerName);
    }
}

