/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.spi.serialization;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.service.FileBasedPersistenceContext;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.impl.config.serializer.DefaultSerializationProviderConfiguration;
import org.ehcache.impl.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.impl.serialization.ByteArraySerializer;
import org.ehcache.impl.serialization.CharSerializer;
import org.ehcache.impl.serialization.CompactJavaSerializer;
import org.ehcache.impl.serialization.DoubleSerializer;
import org.ehcache.impl.serialization.FloatSerializer;
import org.ehcache.impl.serialization.IntegerSerializer;
import org.ehcache.impl.serialization.LongSerializer;
import org.ehcache.impl.serialization.StringSerializer;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.UnsupportedTypeException;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSerializationProvider
implements SerializationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSerializationProvider.class);
    protected final Map<Class<?>, Class<? extends Serializer<?>>> serializers;
    final ConcurrentWeakIdentityHashMap<Serializer<?>, AtomicInteger> providedVsCount = new ConcurrentWeakIdentityHashMap();
    final Set<Serializer<?>> instantiated = Collections.newSetFromMap(new ConcurrentWeakIdentityHashMap());

    public DefaultSerializationProvider(DefaultSerializationProviderConfiguration configuration) {
        this.serializers = configuration != null ? new LinkedHashMap(configuration.getDefaultSerializers()) : new LinkedHashMap(Collections.emptyMap());
    }

    @Override
    public <T> Serializer<T> createKeySerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?, ?> ... configs) throws UnsupportedTypeException {
        DefaultSerializerConfiguration<T> configuration = DefaultSerializationProvider.find(DefaultSerializerConfiguration.Type.KEY, configs);
        Serializer<T> serializer = DefaultSerializationProvider.getUserProvidedSerializer(configuration);
        if (serializer == null) {
            serializer = this.createSerializer(clazz, classLoader, configuration, configs);
            this.instantiated.add(serializer);
        }
        this.updateProvidedInstanceCounts(serializer);
        return serializer;
    }

    @Override
    public <T> Serializer<T> createValueSerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?, ?> ... configs) throws UnsupportedTypeException {
        DefaultSerializerConfiguration<T> configuration = DefaultSerializationProvider.find(DefaultSerializerConfiguration.Type.VALUE, configs);
        Serializer<T> serializer = DefaultSerializationProvider.getUserProvidedSerializer(configuration);
        if (serializer == null) {
            serializer = this.createSerializer(clazz, classLoader, configuration, configs);
            this.instantiated.add(serializer);
        }
        this.updateProvidedInstanceCounts(serializer);
        return serializer;
    }

    private <T> Serializer<T> createSerializer(Class<T> clazz, ClassLoader classLoader, DefaultSerializerConfiguration<T> config, ServiceConfiguration<?, ?> ... configs) throws UnsupportedTypeException {
        Class<Serializer<T>> klazz = this.getSerializerClassFor(clazz, config);
        try {
            klazz.getConstructor(ClassLoader.class, FileBasedPersistenceContext.class);
            LOG.warn(klazz.getName() + " class has a constructor that takes in a FileBasedPersistenceContext. Support for this constructor has been removed since version 3.2. Consider removing it.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            return this.constructSerializer(clazz, klazz.getConstructor(ClassLoader.class), classLoader);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(klazz + " does not have a constructor that takes in a ClassLoader.", e);
        }
    }

    private <T> Class<? extends Serializer<T>> getSerializerClassFor(Class<T> clazz, DefaultSerializerConfiguration<T> config) throws UnsupportedTypeException {
        Class configured;
        if (config != null && (configured = config.getClazz()) != null) {
            return configured;
        }
        Class<? extends Serializer<?>> direct = this.serializers.get(clazz);
        if (direct != null) {
            return direct;
        }
        for (Map.Entry<Class<?>, Class<Serializer<?>>> entry : this.serializers.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            Class<? extends Serializer<?>> type = entry.getValue();
            return type;
        }
        throw new UnsupportedTypeException("No serializer found for type '" + clazz.getName() + "'");
    }

    private <T> Serializer<T> constructSerializer(Class<T> clazz, Constructor<? extends Serializer<T>> constructor, Object ... args) {
        try {
            Serializer<T> serializer = constructor.newInstance(args);
            LOG.debug("Serializer for <{}> : {}", (Object)clazz.getName(), (Object)serializer);
            return serializer;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void updateProvidedInstanceCounts(Serializer<?> serializer) {
        AtomicInteger currentCount = this.providedVsCount.putIfAbsent(serializer, new AtomicInteger(1));
        if (currentCount != null) {
            currentCount.incrementAndGet();
        }
    }

    @Override
    public void releaseSerializer(Serializer<?> serializer) throws IOException {
        AtomicInteger currentCount = this.providedVsCount.get(serializer);
        if (currentCount != null) {
            if (currentCount.decrementAndGet() < 0) {
                currentCount.incrementAndGet();
                throw new IllegalArgumentException("Given serializer:" + serializer.getClass().getName() + " is not managed by this provider");
            }
        } else {
            throw new IllegalArgumentException("Given serializer:" + serializer.getClass().getName() + " is not managed by this provider");
        }
        if (this.instantiated.remove(serializer) && serializer instanceof Closeable) {
            ((Closeable)((Object)serializer)).close();
        }
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        DefaultSerializationProvider.addDefaultSerializerIfNoneRegistered(this.serializers, Serializable.class, CompactJavaSerializer.asTypedSerializer());
        DefaultSerializationProvider.addDefaultSerializerIfNoneRegistered(this.serializers, Long.class, LongSerializer.class);
        DefaultSerializationProvider.addDefaultSerializerIfNoneRegistered(this.serializers, Integer.class, IntegerSerializer.class);
        DefaultSerializationProvider.addDefaultSerializerIfNoneRegistered(this.serializers, Float.class, FloatSerializer.class);
        DefaultSerializationProvider.addDefaultSerializerIfNoneRegistered(this.serializers, Double.class, DoubleSerializer.class);
        DefaultSerializationProvider.addDefaultSerializerIfNoneRegistered(this.serializers, Character.class, CharSerializer.class);
        DefaultSerializationProvider.addDefaultSerializerIfNoneRegistered(this.serializers, String.class, StringSerializer.class);
        DefaultSerializationProvider.addDefaultSerializerIfNoneRegistered(this.serializers, byte[].class, ByteArraySerializer.class);
    }

    @Override
    public void stop() {
    }

    private static <T> void addDefaultSerializerIfNoneRegistered(Map<Class<?>, Class<? extends Serializer<?>>> serializers, Class<T> clazz, Class<? extends Serializer<T>> serializerClass) {
        if (!serializers.containsKey(clazz)) {
            serializers.put(clazz, serializerClass);
        }
    }

    private static <T> Serializer<T> getUserProvidedSerializer(DefaultSerializerConfiguration<T> conf) {
        Serializer instance;
        if (conf != null && (instance = (Serializer)conf.getInstance()) != null) {
            return instance;
        }
        return null;
    }

    private static <T> DefaultSerializerConfiguration<T> find(DefaultSerializerConfiguration.Type type, ServiceConfiguration<?, ?> ... serviceConfigurations) {
        DefaultSerializerConfiguration result = null;
        Collection<DefaultSerializerConfiguration> serializationProviderConfigurations = ServiceUtils.findAmongst(DefaultSerializerConfiguration.class, serviceConfigurations);
        for (DefaultSerializerConfiguration serializationProviderConfiguration : serializationProviderConfigurations) {
            if (serializationProviderConfiguration.getType() != type) continue;
            if (result != null) {
                throw new IllegalArgumentException("Duplicate " + (Object)((Object)type) + " serialization provider : " + serializationProviderConfiguration);
            }
            result = serializationProviderConfiguration;
        }
        return result;
    }
}

