/*
 * Decompiled with CFR 0.152.
 */
package jmccc.cli.launch;

import jmccc.cli.Main;
import jmccc.cli.download.CliDownloader;
import jmccc.cli.launch.CliConfig;
import jmccc.cli.launch.CliListener;
import org.to2mbn.jmccc.launch.Launcher;
import org.to2mbn.jmccc.launch.LauncherBuilder;
import org.to2mbn.jmccc.launch.MissingDependenciesException;
import org.to2mbn.jmccc.option.LaunchOption;
import org.to2mbn.jmccc.version.Library;

public class CliLauncher {
    public static void launch(LaunchOption option) throws Exception {
        Launcher launcher = LauncherBuilder.create().printDebugCommandline(true).build();
        option.commandlineVariables().put("version_type", "JMCCC CLI " + Main.version);
        option.commandlineVariables().put("launcher_name", "JMCCC CLI");
        option.commandlineVariables().put("launcher_version", Main.version);
        option.commandlineVariables().put("clientid", CliConfig.getConfig().clientId);
        CliListener listener = new CliListener();
        System.out.println("Launching version: " + option.getVersion());
        try {
            launcher.launch(option, listener);
        }
        catch (MissingDependenciesException e) {
            for (Library lib : e.getMissingLibraries()) {
                CliDownloader.downloadLibrary(option.getMinecraftDirectory(), lib);
            }
            launcher.launch(option, listener);
        }
    }
}

