/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.version.parsing;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.to2mbn.jmccc.internal.org.json.JSONException;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.util.IOUtils;
import org.to2mbn.jmccc.version.Asset;
import org.to2mbn.jmccc.version.Version;
import org.to2mbn.jmccc.version.parsing.PlatformDescription;
import org.to2mbn.jmccc.version.parsing.VersionParser;
import org.to2mbn.jmccc.version.parsing.VersionParserImpl;

public final class Versions {
    private static final VersionParser PARSER = new VersionParserImpl();

    private Versions() {
    }

    public static Version resolveVersion(MinecraftDirectory minecraftDir, String version) throws IOException {
        Objects.requireNonNull(minecraftDir);
        Objects.requireNonNull(version);
        if (Versions.doesVersionExist(minecraftDir, version)) {
            try {
                return Versions.getVersionParser().parseVersion(Versions.resolveVersionHierarchy(version, minecraftDir), PlatformDescription.current());
            }
            catch (JSONException e) {
                throw new IOException("Couldn't parse version json: " + version, e);
            }
        }
        return null;
    }

    public static Set<String> getVersions(MinecraftDirectory minecraftDir) {
        Objects.requireNonNull(minecraftDir);
        TreeSet<String> versions = new TreeSet<String>();
        File[] subdirs = minecraftDir.getVersions().listFiles();
        if (subdirs != null) {
            for (File file : subdirs) {
                if (!file.isDirectory() || !Versions.doesVersionExist(minecraftDir, file.getName())) continue;
                versions.add(file.getName());
            }
        }
        return Collections.unmodifiableSet(versions);
    }

    public static Set<Asset> resolveAssets(MinecraftDirectory minecraftDir, Version version) throws IOException {
        return Versions.resolveAssets(minecraftDir, version.getAssets());
    }

    public static Set<Asset> resolveAssets(MinecraftDirectory minecraftDir, String assets) throws IOException {
        Objects.requireNonNull(minecraftDir);
        Objects.requireNonNull(assets);
        if (!minecraftDir.getAssetIndex(assets).isFile()) {
            return null;
        }
        try {
            return Versions.getVersionParser().parseAssetIndex(IOUtils.toJson(minecraftDir.getAssetIndex(assets)));
        }
        catch (JSONException e) {
            throw new IOException("Couldn't parse asset index: " + assets, e);
        }
    }

    public static VersionParser getVersionParser() {
        return PARSER;
    }

    private static boolean doesVersionExist(MinecraftDirectory minecraftDir, String version) {
        return minecraftDir.getVersionJson(version).isFile();
    }

    private static Stack<JSONObject> resolveVersionHierarchy(String version, MinecraftDirectory mcdir) throws IOException, JSONException {
        JSONObject json;
        Stack<JSONObject> result = new Stack<JSONObject>();
        do {
            json = IOUtils.toJson(mcdir.getVersionJson(version));
            result.push(json);
        } while ((version = json.optString("inheritsFrom", null)) != null);
        return result;
    }
}

