/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.version.parsing;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.to2mbn.jmccc.internal.org.json.JSONArray;
import org.to2mbn.jmccc.internal.org.json.JSONException;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.util.Arch;
import org.to2mbn.jmccc.version.Asset;
import org.to2mbn.jmccc.version.AssetIndexInfo;
import org.to2mbn.jmccc.version.DownloadInfo;
import org.to2mbn.jmccc.version.Library;
import org.to2mbn.jmccc.version.LibraryInfo;
import org.to2mbn.jmccc.version.Native;
import org.to2mbn.jmccc.version.Version;
import org.to2mbn.jmccc.version.parsing.PlatformDescription;
import org.to2mbn.jmccc.version.parsing.VersionParser;

class VersionParserImpl
implements VersionParser {
    VersionParserImpl() {
    }

    @Override
    public DownloadInfo parseDownloadInfo(JSONObject json) throws JSONException {
        if (json == null) {
            return null;
        }
        String url = json.optString("url", null);
        String checksum = json.optString("sha1", null);
        long size = json.optLong("size", -1L);
        return new DownloadInfo(url, checksum, size);
    }

    @Override
    public AssetIndexInfo parseAssetIndexInfo(JSONObject json) throws JSONException {
        if (json == null) {
            return null;
        }
        DownloadInfo base = this.parseDownloadInfo(json);
        String id = json.getString("id");
        long totalSize = json.optLong("totalSize", -1L);
        return new AssetIndexInfo(base.getUrl(), base.getChecksum(), base.getSize(), id, totalSize);
    }

    @Override
    public LibraryInfo parseLibraryInfo(JSONObject json) throws JSONException {
        if (json == null) {
            return null;
        }
        DownloadInfo base = this.parseDownloadInfo(json);
        String path = json.optString("path", null);
        return new LibraryInfo(base.getUrl(), base.getChecksum(), base.getSize(), path);
    }

    @Override
    public Library parseLibrary(JSONObject json, PlatformDescription platformDescription) throws JSONException {
        if (json == null) {
            return null;
        }
        if (!this.checkAllowed(json.optJSONArray("rules"), platformDescription) || !json.optBoolean("clientreq", true)) {
            return null;
        }
        String[] splitedGav = json.getString("name").split(":", 4);
        String groupId = splitedGav[0];
        String artifactId = splitedGav[1];
        String version = splitedGav[2];
        String url = json.optString("url", null);
        String[] checksums = this.parseChecksums(json.optJSONArray("checksums"));
        JSONObject jsonNatives = json.optJSONObject("natives");
        boolean isNative = jsonNatives != null;
        String classifier = isNative ? this.parseNativeClassifier(json.getJSONObject("natives"), platformDescription) : null;
        LibraryInfo libinfo = this.parseLibraryDownloads(json.optJSONObject("downloads"), classifier);
        if (splitedGav.length == 4) {
            classifier = splitedGav[3];
        }
        String type = "jar";
        if (isNative) {
            if (classifier == null) {
                return null;
            }
            Set<String> excludes = this.parseExtractExcludes(json.optJSONObject("extract"));
            return new Native(groupId, artifactId, version, classifier, type, libinfo, url, checksums, excludes);
        }
        return new Library(groupId, artifactId, version, classifier, type, libinfo, url, checksums);
    }

    @Override
    public Set<Asset> parseAssetIndex(JSONObject json) throws JSONException {
        if (json == null) {
            return null;
        }
        JSONObject objects = json.getJSONObject("objects");
        TreeSet<Asset> assets = new TreeSet<Asset>(new Comparator<Asset>(){

            @Override
            public int compare(Asset o1, Asset o2) {
                return o1.getVirtualPath().compareTo(o2.getVirtualPath());
            }
        });
        Iterator<String> iterator = objects.keySet().iterator();
        while (iterator.hasNext()) {
            String rawVirtualPath;
            String virtualPath = rawVirtualPath = iterator.next();
            JSONObject object = objects.getJSONObject(virtualPath);
            String hash = object.getString("hash");
            int size = object.getInt("size");
            assets.add(new Asset(virtualPath, hash, size));
        }
        return Collections.unmodifiableSet(assets);
    }

    @Override
    public Version parseVersion(Stack<JSONObject> hierarchy, PlatformDescription platformDescription) throws JSONException {
        String version = ((JSONObject)hierarchy.get(0)).getString("id");
        String root = hierarchy.peek().getString("id");
        String assets = "legacy";
        String mainClass = null;
        String launchArgs = null;
        ArrayDeque<List<String>> gameArgsDeque = new ArrayDeque<List<String>>();
        ArrayDeque<List<String>> jvmArgsDeque = new ArrayDeque<List<String>>();
        String type = null;
        TreeMap<String, Library> librariesMap = new TreeMap<String, Library>();
        TreeMap<String, DownloadInfo> downloads = new TreeMap<String, DownloadInfo>();
        AssetIndexInfo assetIndexInfo = null;
        do {
            JSONObject jsonAssetIndexInfo;
            Map<String, DownloadInfo> currentDownloads;
            JSONObject json = hierarchy.pop();
            assets = json.optString("assets", assets);
            mainClass = json.optString("mainClass", mainClass);
            launchArgs = json.has("minecraftArguments") ? json.getString("minecraftArguments") : launchArgs;
            type = json.optString("type", type);
            JSONObject arguments = json.optJSONObject("arguments");
            gameArgsDeque.addLast(this.parseArguments(arguments, "game", platformDescription));
            jvmArgsDeque.addLast(this.parseArguments(arguments, "jvm", platformDescription));
            Set<Library> currentLibraries = this.parseLibraries(json.optJSONArray("libraries"), platformDescription);
            if (currentLibraries != null) {
                for (Library library : currentLibraries) {
                    StringBuilder libId = new StringBuilder();
                    libId.append(library.getGroupId()).append(':').append(library.getArtifactId());
                    if (library.getClassifier() != null) {
                        libId.append(':').append(library.getClassifier());
                    }
                    librariesMap.put(libId.toString(), library);
                }
            }
            if ((currentDownloads = this.parseDownloads(json.optJSONObject("downloads"))) != null) {
                downloads.putAll(currentDownloads);
            }
            if ((jsonAssetIndexInfo = json.optJSONObject("assetIndex")) == null) continue;
            assetIndexInfo = this.parseAssetIndexInfo(jsonAssetIndexInfo);
        } while (!hierarchy.isEmpty());
        List<String> gameArgs = this.mergeArgument(gameArgsDeque);
        if (launchArgs != null) {
            gameArgs.addAll(Arrays.asList(launchArgs.split(" ")));
        }
        List<String> jvmArgs = this.mergeArgument(jvmArgsDeque);
        if (mainClass == null) {
            throw new JSONException("Missing mainClass");
        }
        if (launchArgs == null && gameArgs.isEmpty()) {
            throw new JSONException("Missing minecraftArguments");
        }
        LinkedHashSet libraries = new LinkedHashSet(librariesMap.values());
        return new Version(version, type, mainClass, assets, gameArgs, jvmArgs, root, Collections.unmodifiableSet(libraries), assets.equals("legacy"), assetIndexInfo, Collections.unmodifiableMap(downloads));
    }

    @Override
    public boolean checkAllowed(JSONArray rules, PlatformDescription platformDescription) throws JSONException {
        if (rules == null || rules.length() == 0) {
            return true;
        }
        boolean allow = false;
        for (int i = 0; i < rules.length(); ++i) {
            JSONObject rule = rules.getJSONObject(i);
            boolean action = rule.get("action").equals("allow");
            boolean apply = true;
            if (rule.has("os")) {
                apply = false;
                JSONObject osRule = rule.getJSONObject("os");
                String name = osRule.optString("name", null);
                String version = osRule.has("version") ? osRule.getString("version") : null;
                String arch = osRule.optString("arch", null);
                if (!(name != null && !platformDescription.getPlatform().name().equalsIgnoreCase(name) || version != null && !platformDescription.getVersion().matches(version) || arch != null && !platformDescription.getArch().name().equalsIgnoreCase(arch))) {
                    apply = true;
                }
            }
            if (rule.has("features")) {
                apply = false;
            }
            if (!apply) continue;
            allow = action;
        }
        return allow;
    }

    private String[] parseChecksums(JSONArray json) throws JSONException {
        if (json == null) {
            return null;
        }
        String[] checksums = new String[json.length()];
        for (int i = 0; i < json.length(); ++i) {
            checksums[i] = json.getString(i);
        }
        return checksums;
    }

    private String parseNativeClassifier(JSONObject natives, PlatformDescription platform) throws JSONException {
        if (natives == null) {
            return null;
        }
        String classifier = natives.optString(platform.getPlatform().name().toLowerCase(), null);
        if (classifier != null) {
            classifier = classifier.replaceAll("\\Q${arch}", Arch.SIMPLE);
        }
        return classifier;
    }

    private Set<String> parseExtractExcludes(JSONObject json) throws JSONException {
        if (json == null) {
            return null;
        }
        JSONArray elements = json.optJSONArray("exclude");
        if (elements == null) {
            return null;
        }
        LinkedHashSet<String> excludes = new LinkedHashSet<String>();
        for (Object element : elements) {
            excludes.add((String)element);
        }
        return Collections.unmodifiableSet(excludes);
    }

    private LibraryInfo parseLibraryDownloads(JSONObject json, String classifier) throws JSONException {
        JSONObject artifact;
        if (json == null) {
            return null;
        }
        if (classifier == null) {
            artifact = json.optJSONObject("artifact");
        } else {
            JSONObject classifiers = json.optJSONObject("classifiers");
            if (classifiers == null) {
                return null;
            }
            artifact = classifiers.optJSONObject(classifier);
        }
        if (artifact == null) {
            return null;
        }
        return this.parseLibraryInfo(artifact);
    }

    private Set<Library> parseLibraries(JSONArray json, PlatformDescription platform) throws JSONException {
        if (json == null) {
            return null;
        }
        HashSet<Library> libraries = new HashSet<Library>();
        for (Object element : json) {
            Library library = this.parseLibrary((JSONObject)element, platform);
            if (library == null) continue;
            libraries.add(library);
        }
        return libraries;
    }

    private Map<String, DownloadInfo> parseDownloads(JSONObject json) throws JSONException {
        if (json == null) {
            return null;
        }
        HashMap<String, DownloadInfo> downloads = new HashMap<String, DownloadInfo>();
        for (String key : json.keySet()) {
            downloads.put(key, this.parseDownloadInfo(json.getJSONObject(key)));
        }
        return downloads;
    }

    private List<String> parseArguments(JSONObject arguments, String key, PlatformDescription platformDescription) {
        if (arguments == null || !arguments.has(key)) {
            return Collections.emptyList();
        }
        return this.parseArgument(arguments.getJSONArray(key), platformDescription);
    }

    private List<String> parseArgument(Object json, PlatformDescription platformDescription) {
        if (json instanceof String) {
            return Collections.singletonList((String)json);
        }
        if (json instanceof JSONArray) {
            ArrayList<String> ret = new ArrayList<String>();
            JSONArray array = (JSONArray)json;
            for (Object obj : array) {
                ret.addAll(this.parseArgument(obj, platformDescription));
            }
            return ret;
        }
        if (json instanceof JSONObject) {
            JSONObject obj = (JSONObject)json;
            boolean allow = true;
            if (obj.has("rules")) {
                allow = this.checkAllowed(obj.getJSONArray("rules"), platformDescription);
            }
            if (allow) {
                return this.parseArgument(obj.get("value"), platformDescription);
            }
        }
        return Collections.emptyList();
    }

    private List<String> mergeArgument(Deque<List<String>> deque) {
        ArrayList<String> ret = new ArrayList<String>();
        while (!deque.isEmpty()) {
            ret.addAll((Collection<String>)deque.removeFirst());
        }
        return ret;
    }
}

