/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.version.parsing;

import java.util.Objects;
import org.to2mbn.jmccc.util.Arch;
import org.to2mbn.jmccc.util.Platform;

public class PlatformDescription {
    private Platform platform;
    private String version;
    private Arch arch;

    public PlatformDescription(Platform platform, String version, Arch arch) {
        this.platform = Objects.requireNonNull(platform);
        this.version = version;
        this.arch = Objects.requireNonNull(arch);
    }

    public static PlatformDescription current() {
        return new PlatformDescription(Platform.CURRENT, System.getProperty("os.version"), Arch.CURRENT);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    public Arch getArch() {
        return this.arch;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.platform, this.version, this.arch});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PlatformDescription) {
            PlatformDescription another = (PlatformDescription)obj;
            return this.platform == another.platform && Objects.equals(this.version, another.version) && Objects.equals((Object)this.arch, (Object)another.arch);
        }
        return false;
    }

    public String toString() {
        return String.format("PlatformDescription [platform=%s, version=%s, arch=%s]", new Object[]{this.platform, this.version, this.arch});
    }
}

