/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.version;

import java.io.Serializable;
import java.util.Objects;

public class Artifact
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type = "jar";

    public Artifact(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, "jar");
    }

    public Artifact(String groupId, String artifactId, String version, String classifier, String type) {
        this.groupId = Objects.requireNonNull(groupId);
        this.artifactId = Objects.requireNonNull(artifactId);
        this.version = Objects.requireNonNull(version);
        this.classifier = classifier;
        this.type = Objects.requireNonNull(type);
    }

    public static String getArtifactBasePath(String groupId, String artifactId, String version) {
        return groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/";
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSnapshotArtifact() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public String getPath() {
        return this.getPath0(this.version);
    }

    public String getPath(String snapshotPostfix) {
        if (!this.isSnapshotArtifact()) {
            throw new IllegalArgumentException("The artifact is not a snapshot.");
        }
        return this.getPath0(this.version.substring(0, this.version.length() - "SNAPSHOT".length()) + snapshotPostfix);
    }

    private String getPath0(String version0) {
        return Artifact.getArtifactBasePath(this.groupId, this.artifactId, this.version) + this.artifactId + "-" + version0 + (this.classifier == null ? "" : "-" + this.classifier) + "." + this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Artifact) {
            Artifact another = (Artifact)obj;
            return Objects.equals(this.groupId, another.groupId) && Objects.equals(this.artifactId, another.artifactId) && Objects.equals(this.version, another.version) && Objects.equals(this.classifier, another.classifier) && Objects.equals(this.type, another.type);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier, this.type);
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + (this.classifier == null ? "" : ":" + this.classifier);
    }
}

