/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.to2mbn.jmccc.internal.org.json.JSONException;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.internal.org.json.JSONTokener;

public final class IOUtils {
    private IOUtils() {
    }

    public static JSONObject toJson(File file) throws JSONException, IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), "UTF-8");){
            JSONObject jSONObject = new JSONObject(new JSONTokener(reader));
            return jSONObject;
        }
    }

    public static JSONObject toJson(byte[] data) throws JSONException {
        return new JSONObject(IOUtils.toString(data));
    }

    public static String toString(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            String string = IOUtils.toString(in);
            return string;
        }
    }

    public static String toString(InputStream in) throws IOException {
        int read;
        CharArrayWriter w = new CharArrayWriter();
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        char[] buf = new char[4096];
        while ((read = reader.read(buf)) != -1) {
            w.write(buf, 0, read);
        }
        return new String(w.toCharArray());
    }

    public static String toString(byte[] data) {
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is not supported", e);
        }
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }
}

