/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.util;

import org.to2mbn.jmccc.util.Platform;

public enum Arch {
    DEFAULT,
    X86,
    ARM64;

    public static final Arch CURRENT;
    public static final String SIMPLE;

    public static Arch inferArch(String archName) {
        if (archName == null || archName.equals("")) {
            return DEFAULT;
        }
        switch (archName) {
            case "aarch64": 
            case "arm64": {
                return ARM64;
            }
            case "i386": 
            case "i486": 
            case "x86": 
            case "32": {
                return X86;
            }
        }
        return DEFAULT;
    }

    static {
        CURRENT = Arch.inferArch(System.getProperty("os.arch"));
        SIMPLE = Platform.isX64() ? "64" : "32";
    }
}

