/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.option;

import java.io.File;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import org.to2mbn.jmccc.version.Asset;
import org.to2mbn.jmccc.version.Library;
import org.to2mbn.jmccc.version.Version;

public class MinecraftDirectory
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected File rootDir;
    protected Path rootPath;

    public MinecraftDirectory() {
        this(new File(".minecraft"));
    }

    public MinecraftDirectory(String rootDir) {
        this(new File(rootDir));
    }

    public MinecraftDirectory(File rootDir) {
        Objects.requireNonNull(rootDir);
        this.rootDir = rootDir.getAbsoluteFile();
        this.rootPath = rootDir.toPath();
    }

    public File getRoot() {
        return this.rootDir;
    }

    public File getVersions() {
        return new File(this.rootDir, "versions");
    }

    public File getLibraries() {
        return new File(this.rootDir, "libraries");
    }

    public File getLibrary(Library library) {
        return new File(this.getLibraries(), library.getPath());
    }

    public File getNatives(String version) {
        return new File(this.getVersion(version), version + "-natives");
    }

    public File getNatives(Version version) {
        return this.getNatives(version.getRoot());
    }

    public File getAssets() {
        return new File(this.rootDir, "assets");
    }

    public File getVirtualAssets() {
        return new File(this.getAssets(), "virtual");
    }

    public File getVirtualLegacyAssets() {
        return new File(this.getVirtualAssets(), "legacy");
    }

    public File getAssetObjects() {
        return new File(this.getAssets(), "objects");
    }

    public File getAssetIndexes() {
        return new File(this.getAssets(), "indexes");
    }

    public File getAssetIndex(String assets) {
        return new File(this.getAssetIndexes(), assets + ".json");
    }

    public File getAssetIndex(Version version) {
        return this.getAssetIndex(version.getAssets());
    }

    public File getVersion(String version) {
        return new File(this.getVersions(), version);
    }

    public File getVersionJson(String version) {
        return new File(this.getVersion(version), version + ".json");
    }

    public File getVersionJson(Version version) {
        return this.getVersionJson(version.getVersion());
    }

    public File getVersionJar(String version) {
        return new File(this.getVersion(version), version + ".jar");
    }

    public File getVersionJar(Version version) {
        File current = this.getVersionJar(version.getVersion());
        if (current.exists()) {
            return current;
        }
        File root = this.getVersionJar(version.getRoot());
        try {
            Files.copy(root.toPath(), current.toPath(), new CopyOption[0]);
            return current;
        }
        catch (Exception e) {
            return root;
        }
    }

    public File getAsset(Asset asset) {
        return new File(this.getAssetObjects(), asset.getPath());
    }

    public File getVirtualAsset(Asset asset) {
        return new File(this.getVirtualLegacyAssets(), asset.getVirtualPath());
    }

    public String getAbsolutePath() {
        return this.rootDir.getAbsolutePath();
    }

    public String toString() {
        return this.rootDir.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MinecraftDirectory) {
            MinecraftDirectory another = (MinecraftDirectory)obj;
            return this.rootDir.equals(another.rootDir);
        }
        return false;
    }

    public int hashCode() {
        return this.rootDir.hashCode();
    }

    public Path get(String path) {
        return this.rootDir.toPath().resolve(path);
    }
}

