/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.option;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.to2mbn.jmccc.auth.Authenticator;
import org.to2mbn.jmccc.option.JavaEnvironment;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.option.ServerInfo;
import org.to2mbn.jmccc.option.WindowSize;
import org.to2mbn.jmccc.version.Version;
import org.to2mbn.jmccc.version.parsing.Versions;

public class LaunchOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int maxMemory = 1024;
    private int minMemory;
    private Version version;
    private Authenticator authenticator;
    private ServerInfo serverInfo;
    private WindowSize windowSize;
    private JavaEnvironment javaEnvironment;
    private MinecraftDirectory minecraftDirectory;
    private MinecraftDirectory runtimeDirectory;
    private List<String> extraJvmArguments = new ArrayList<String>();
    private List<String> extraMinecraftArguments = new ArrayList<String>();
    private Map<String, String> commandlineVariables = new LinkedHashMap<String, String>();
    private Set<File> extraClasspath = new LinkedHashSet<File>();

    public LaunchOption(String version, Authenticator authenticator, MinecraftDirectory minecraftDir) throws IOException {
        this(LaunchOption.requireVersion(minecraftDir, version), authenticator, minecraftDir);
    }

    public LaunchOption(Version version, Authenticator authenticator, MinecraftDirectory minecraftDir) {
        Objects.requireNonNull(version);
        Objects.requireNonNull(authenticator);
        Objects.requireNonNull(minecraftDir);
        this.version = version;
        this.authenticator = authenticator;
        this.minecraftDirectory = minecraftDir;
        this.runtimeDirectory = minecraftDir;
        this.javaEnvironment = JavaEnvironment.current();
    }

    private static Version requireVersion(MinecraftDirectory mcdir, String version) throws IOException {
        Version result = Versions.resolveVersion(mcdir, version);
        if (result == null) {
            throw new IllegalArgumentException("Version not found: " + version);
        }
        return result;
    }

    public Version getVersion() {
        return this.version;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public MinecraftDirectory getMinecraftDirectory() {
        return this.minecraftDirectory;
    }

    public JavaEnvironment getJavaEnvironment() {
        return this.javaEnvironment;
    }

    public void setJavaEnvironment(JavaEnvironment javaEnvironment) {
        this.javaEnvironment = javaEnvironment;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(int maxMemory) {
        if (maxMemory < 0) {
            throw new IllegalArgumentException("maxMemory<0");
        }
        this.maxMemory = maxMemory;
    }

    public int getMinMemory() {
        return this.minMemory;
    }

    public void setMinMemory(int minMemory) {
        if (minMemory < 0) {
            throw new IllegalArgumentException("minMemory<0");
        }
        this.minMemory = minMemory;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public WindowSize getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(WindowSize windowSize) {
        this.windowSize = windowSize;
    }

    public MinecraftDirectory getRuntimeDirectory() {
        return this.runtimeDirectory;
    }

    public void setRuntimeDirectory(MinecraftDirectory runtimeDirectory) {
        Objects.requireNonNull(runtimeDirectory);
        this.runtimeDirectory = runtimeDirectory;
    }

    public List<String> extraJvmArguments() {
        return this.extraJvmArguments;
    }

    public List<String> extraMinecraftArguments() {
        return this.extraMinecraftArguments;
    }

    public Map<String, String> commandlineVariables() {
        return this.commandlineVariables;
    }

    public Set<File> extraClasspath() {
        return this.extraClasspath;
    }

    public String toString() {
        return "LaunchOption [maxMemory=" + this.maxMemory + ", minMemory=" + this.minMemory + ", version=" + this.version + ", authenticator=" + this.authenticator + ", serverInfo=" + this.serverInfo + ", windowSize=" + this.windowSize + ", javaEnvironment=" + this.javaEnvironment + ", minecraftDirectory=" + this.minecraftDirectory + ", runtimeDirectory=" + this.runtimeDirectory + ", extraJvmArguments=" + this.extraJvmArguments + ", extraMinecraftArguments=" + this.extraMinecraftArguments + ", commandlineVariables=" + this.commandlineVariables + ", extraClasspath=" + this.extraClasspath + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LaunchOption) {
            LaunchOption another = (LaunchOption)obj;
            return this.maxMemory == another.maxMemory && this.minMemory == another.minMemory && Objects.equals(this.version, another.version) && Objects.equals(this.authenticator, another.authenticator) && Objects.equals(this.minecraftDirectory, another.minecraftDirectory) && Objects.equals(this.runtimeDirectory, another.runtimeDirectory) && Objects.equals(this.javaEnvironment, another.javaEnvironment) && Objects.equals(this.serverInfo, another.serverInfo) && Objects.equals(this.windowSize, another.windowSize) && Objects.equals(this.extraJvmArguments, another.extraJvmArguments) && Objects.equals(this.extraMinecraftArguments, another.extraMinecraftArguments) && Objects.equals(this.commandlineVariables, another.commandlineVariables) && Objects.equals(this.extraClasspath, another.extraClasspath);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.authenticator, this.minecraftDirectory);
    }
}

