/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.forge;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.to2mbn.jmccc.mcdownloader.download.tasks.ResultProcessor;
import org.to2mbn.jmccc.util.FileUtils;

class UniversalDecompressor
implements ResultProcessor<byte[], Void> {
    private static final String NAME_TEMPLATE = "forge-%s-universal.jar";
    private static final String OLD_NAME_TEMPLATE = "minecraftforge-universal-%s.jar";
    private File target;
    private String[] names;

    public UniversalDecompressor(File target, String m2Version) {
        this.target = target;
        this.names = new String[]{String.format(NAME_TEMPLATE, m2Version), String.format(OLD_NAME_TEMPLATE, m2Version)};
    }

    @Override
    public Void process(byte[] arg) throws Exception {
        try (ZipInputStream in = new ZipInputStream(new ByteArrayInputStream(arg));){
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                if (this.isUniversalJar(entry.getName())) {
                    FileUtils.prepareWrite(this.target);
                    try (FileOutputStream out = new FileOutputStream(this.target);){
                        int read;
                        byte[] buf = new byte[8192];
                        while ((read = in.read(buf)) != -1) {
                            ((OutputStream)out).write(buf, 0, read);
                        }
                    }
                    in.closeEntry();
                    Void void_ = null;
                    return void_;
                }
                in.closeEntry();
            }
        }
        throw new IllegalArgumentException("No universal jar found");
    }

    private boolean isUniversalJar(String name) {
        for (String expectedName : this.names) {
            if (!expectedName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

