/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.forge;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.to2mbn.jmccc.internal.org.json.JSONArray;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.mcdownloader.provider.forge.ForgeVersion;

public class ForgeVersionList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, List<ForgeVersion>> versions;
    private final Map<String, ForgeVersion> latests;
    private final Map<String, ForgeVersion> recommendeds;
    private final Map<String, ForgeVersion> forgeVersionMapping;
    private final ForgeVersion latest;
    private final ForgeVersion recommended;

    public ForgeVersionList(Map<String, List<ForgeVersion>> versions, Map<String, ForgeVersion> latests, Map<String, ForgeVersion> recommendeds, Map<String, ForgeVersion> forgeVersionMapping, ForgeVersion latest, ForgeVersion recommended) {
        Objects.requireNonNull(versions);
        Objects.requireNonNull(latests);
        Objects.requireNonNull(recommendeds);
        Objects.requireNonNull(forgeVersionMapping);
        this.versions = versions;
        this.latests = latests;
        this.recommendeds = recommendeds;
        this.forgeVersionMapping = forgeVersionMapping;
        this.latest = latest;
        this.recommended = recommended;
    }

    public static ForgeVersionList fromJson(JSONObject metaJson, JSONObject promoJson) {
        TreeMap<String, List> versions = new TreeMap<String, List>();
        TreeMap<String, ForgeVersion> latests = new TreeMap<String, ForgeVersion>();
        TreeMap<String, ForgeVersion> recommendeds = new TreeMap<String, ForgeVersion>();
        TreeMap<String, ForgeVersion> forgeVersionMapping = new TreeMap<String, ForgeVersion>();
        ForgeVersion latest = null;
        ForgeVersion recommended = null;
        for (String mcVersion : metaJson.keySet()) {
            JSONArray versionJson = metaJson.getJSONArray(mcVersion);
            for (Object forgeVersionObj : versionJson) {
                ForgeVersion version = ForgeVersion.from((String)forgeVersionObj);
                versions.computeIfAbsent(mcVersion, it -> new ArrayList()).add(version);
                forgeVersionMapping.put(version.getForgeVersion(), version);
            }
        }
        JSONObject promos = promoJson.getJSONObject("promos");
        for (String key : promos.keySet()) {
            ForgeVersion version = (ForgeVersion)forgeVersionMapping.get(promos.getString(key));
            if (key.endsWith("-latest")) {
                latests.put(key.substring(0, key.length() - 7), version);
                latest = version;
                continue;
            }
            if (!key.endsWith("-recommended")) continue;
            recommendeds.put(key.substring(0, key.length() - 12), version);
            recommended = version;
        }
        return new ForgeVersionList(Collections.unmodifiableMap(versions), Collections.unmodifiableMap(latests), Collections.unmodifiableMap(recommendeds), Collections.unmodifiableMap(forgeVersionMapping), latest, recommended);
    }

    public List<ForgeVersion> getVersions(String mcversion) {
        return this.versions.get(mcversion);
    }

    public Map<String, ForgeVersion> getLatests() {
        return this.latests;
    }

    public Map<String, ForgeVersion> getRecommendeds() {
        return this.recommendeds;
    }

    public ForgeVersion getLatest() {
        return this.latest;
    }

    public ForgeVersion getLatest(String mcversion) {
        return this.latests.get(mcversion);
    }

    public ForgeVersion getRecommended() {
        return this.recommended;
    }

    public ForgeVersion getRecommended(String mcversion) {
        return this.recommendeds.get(mcversion);
    }

    public Map<String, ForgeVersion> getForgeVersionMapping() {
        return this.forgeVersionMapping;
    }

    public ForgeVersion get(String mcversion, int buildNumber) {
        return this.versions.get(mcversion).get(buildNumber);
    }

    public ForgeVersion get(String forgeVersion) {
        return this.forgeVersionMapping.get(forgeVersion);
    }

    public int hashCode() {
        return this.versions.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ForgeVersionList) {
            ForgeVersionList another = (ForgeVersionList)obj;
            return Objects.equals(this.versions, another.versions) && Objects.equals(this.latests, another.latests) && Objects.equals(this.recommendeds, another.recommendeds) && Objects.equals(this.forgeVersionMapping, another.forgeVersionMapping) && Objects.equals(this.latest, another.latest) && Objects.equals(this.recommended, another.recommended);
        }
        return false;
    }

    public String toString() {
        return String.format("ForgeVersionList [versions=%s, latests=%s, recommendeds=%s, forgeVersionMapping=%s, latest=%s, recommended=%s]", this.versions, this.latests, this.recommendeds, this.forgeVersionMapping, this.latest, this.recommended);
    }
}

