/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.forge;

import java.io.Serializable;
import java.util.Objects;

public class ForgeVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String minecraftVersion;
    private final String forgeVersion;
    private final int buildNumber;
    private final String branch;

    public ForgeVersion(String minecraftVersion, String forgeVersion, int buildNumber, String branch) {
        this.minecraftVersion = Objects.requireNonNull(minecraftVersion);
        this.forgeVersion = Objects.requireNonNull(forgeVersion);
        this.buildNumber = buildNumber;
        this.branch = branch;
    }

    public static ForgeVersion from(String fullVersion) {
        String[] split = fullVersion.split("-", 3);
        String mcVersion = split[0];
        String forgeVersion = split[1];
        String[] split1 = forgeVersion.split("\\.");
        int buildNumber = Integer.parseInt(split1[split1.length - 1]);
        String branch = split.length == 3 ? split[2] : null;
        return new ForgeVersion(mcVersion, forgeVersion, buildNumber, branch);
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getForgeVersion() {
        return this.forgeVersion;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getVersionName() {
        return this.minecraftVersion + "-forge-" + this.forgeVersion;
    }

    public String getMavenVersion() {
        String ver = this.minecraftVersion + "-" + this.forgeVersion;
        if (this.branch != null) {
            ver = ver + "-" + this.branch;
        }
        return ver;
    }

    public String toString() {
        return this.getVersionName();
    }

    public int hashCode() {
        return this.forgeVersion.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ForgeVersion) {
            ForgeVersion another = (ForgeVersion)obj;
            return Objects.equals(this.minecraftVersion, another.minecraftVersion) && Objects.equals(this.forgeVersion, another.forgeVersion) && this.buildNumber == another.buildNumber && Objects.equals(this.branch, another.branch);
        }
        return false;
    }
}

