/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.fabric;

import java.util.ArrayList;
import java.util.List;
import org.to2mbn.jmccc.internal.org.json.JSONArray;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.mcdownloader.provider.fabric.FabricVersion;

public class FabricVersionList {
    private final List<String> minecraftReleaseVersions;
    private final List<String> minecraftSnapshotVersions;
    private final List<String> fabricLoaderVersions;
    private final String loaderName;

    public FabricVersionList(List<String> minecraftReleaseVersions, List<String> minecraftSnapshotVersions, List<String> fabricLoaderVersions, String loaderName) {
        this.minecraftReleaseVersions = minecraftReleaseVersions;
        this.minecraftSnapshotVersions = minecraftSnapshotVersions;
        this.fabricLoaderVersions = fabricLoaderVersions;
        this.loaderName = loaderName;
    }

    public FabricVersion getLatest(String minecraftVersion) {
        return new FabricVersion(minecraftVersion, this.fabricLoaderVersions.get(0), this.loaderName);
    }

    public FabricVersion getLatestRelease() {
        return new FabricVersion(this.minecraftReleaseVersions.get(0), this.fabricLoaderVersions.get(0), this.loaderName);
    }

    public FabricVersion getLatestSnapshot() {
        return new FabricVersion(this.minecraftSnapshotVersions.get(0), this.fabricLoaderVersions.get(0), this.loaderName);
    }

    public static FabricVersionList fromJson(JSONObject json) {
        JSONArray game = json.getJSONArray("game");
        ArrayList<String> minecraftReleaseVersions = new ArrayList<String>();
        ArrayList<String> minecraftSnapshotVersions = new ArrayList<String>();
        for (Object obj : game) {
            JSONObject it = (JSONObject)obj;
            (it.getBoolean("stable") ? minecraftReleaseVersions : minecraftSnapshotVersions).add(it.getString("version"));
        }
        JSONArray loader = json.getJSONArray("loader");
        ArrayList<String> fabricLoaderVersions = new ArrayList<String>();
        String loaderName = "fabric";
        for (Object obj : loader) {
            JSONObject it = (JSONObject)obj;
            if (it.getString("maven").contains("quilt")) {
                loaderName = "quilt";
            }
            fabricLoaderVersions.add(it.getString("version"));
        }
        return new FabricVersionList(minecraftReleaseVersions, minecraftSnapshotVersions, fabricLoaderVersions, loaderName);
    }

    public String toString() {
        return "FabricVersionList{ Latest: " + this.fabricLoaderVersions.get(0) + " }";
    }
}

