/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider.fabric;

import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.MemoryDownloadTask;
import org.to2mbn.jmccc.mcdownloader.provider.AbstractMinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.ExtendedDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.JsonDecoder;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.VersionJsonInstaller;
import org.to2mbn.jmccc.mcdownloader.provider.fabric.FabricDownloadSource;
import org.to2mbn.jmccc.mcdownloader.provider.fabric.FabricVersion;
import org.to2mbn.jmccc.mcdownloader.provider.fabric.FabricVersionList;
import org.to2mbn.jmccc.option.MinecraftDirectory;

public class FabricDownloadProvider
extends AbstractMinecraftDownloadProvider
implements ExtendedDownloadProvider {
    private MinecraftDownloadProvider upstreamProvider;
    private FabricDownloadSource source;

    public FabricDownloadProvider(FabricDownloadSource source) {
        this.source = source;
    }

    public FabricDownloadProvider() {
        this(new FabricDownloadSource.Default());
    }

    @Override
    public void setUpstreamProvider(MinecraftDownloadProvider upstreamProvider) {
        this.upstreamProvider = upstreamProvider;
    }

    public CombinedDownloadTask<FabricVersionList> fabricVersionList() {
        return CombinedDownloadTask.single(new MemoryDownloadTask(this.source.getFabricVersionsUrl()).andThen(new JsonDecoder()).andThen(FabricVersionList::fromJson).cacheable().cachePool("org.to2mbn.jmccc.mcdownloader.cache.dynamic.fabric.versionList"));
    }

    @Override
    public CombinedDownloadTask<String> gameVersionJson(MinecraftDirectory mcdir, String version) {
        FabricVersion fabricVersion = FabricVersion.resolve(this.getLoaderName(), version);
        if (fabricVersion == null) {
            return null;
        }
        String url = this.source.getFabricProfileUrl(fabricVersion.getMinecraftVersion(), fabricVersion.getFabricLoaderVersion());
        return CombinedDownloadTask.single(new MemoryDownloadTask(url)).andThen(new JsonDecoder()).andThen(new VersionJsonInstaller(mcdir));
    }

    protected String getLoaderName() {
        return "fabric";
    }
}

