/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider;

import java.io.IOException;
import java.net.URI;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.mcdownloader.RemoteVersionList;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.FileDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.MemoryDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.ResultProcessor;
import org.to2mbn.jmccc.mcdownloader.provider.JarLibraryDownloadHandler;
import org.to2mbn.jmccc.mcdownloader.provider.JsonDecoder;
import org.to2mbn.jmccc.mcdownloader.provider.LibraryDownloadHandler;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.PackLibraryDownloadHandler;
import org.to2mbn.jmccc.mcdownloader.provider.XZPackLibraryDownloadHandler;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.version.Asset;
import org.to2mbn.jmccc.version.Library;
import org.to2mbn.jmccc.version.Version;
import org.to2mbn.jmccc.version.parsing.Versions;

public abstract class URIDownloadProvider
implements MinecraftDownloadProvider {
    private Map<String, LibraryDownloadHandler> libraryHandlers = new ConcurrentSkipListMap<String, LibraryDownloadHandler>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int result = o2.length() - o1.length();
            if (result == 0) {
                result = o1.compareTo(o2);
            }
            return result;
        }
    });

    public URIDownloadProvider() {
        this.registerLibraryDownloadHandler(".jar", new JarLibraryDownloadHandler());
        this.registerLibraryDownloadHandler(".pack", new PackLibraryDownloadHandler());
        this.registerLibraryDownloadHandler(".pack.xz", new XZPackLibraryDownloadHandler());
    }

    protected URI[] getLibrary(Library library) {
        return null;
    }

    protected URI getGameJar(Version version) {
        return null;
    }

    protected URI getGameVersionJson(String version) {
        return null;
    }

    protected URI getAssetIndex(Version version) {
        return null;
    }

    protected URI getVersionList() {
        return null;
    }

    protected URI getAsset(Asset asset) {
        return null;
    }

    @Override
    public CombinedDownloadTask<RemoteVersionList> versionList() {
        URI uri = this.getVersionList();
        if (uri == null) {
            return null;
        }
        return CombinedDownloadTask.single(new MemoryDownloadTask(uri).andThen(new JsonDecoder()).andThen(new ResultProcessor<JSONObject, RemoteVersionList>(){

            @Override
            public RemoteVersionList process(JSONObject json) throws Exception {
                return RemoteVersionList.fromJson(json);
            }
        }).cacheable().cachePool("org.to2mbn.jmccc.mcdownloader.cache.dynamic.versionList"));
    }

    @Override
    public CombinedDownloadTask<Set<Asset>> assetsIndex(final MinecraftDirectory mcdir, final Version version) {
        URI uri = this.getAssetIndex(version);
        if (uri == null) {
            return null;
        }
        return CombinedDownloadTask.single(new FileDownloadTask(uri, mcdir.getAssetIndex(version.getAssets())).andThen(new ResultProcessor<Void, Set<Asset>>(){

            @Override
            public Set<Asset> process(Void arg) throws IOException {
                return Versions.resolveAssets(mcdir, version);
            }
        }).cachePool("org.to2mbn.jmccc.mcdownloader.cache.static.assetsIndex"));
    }

    @Override
    public CombinedDownloadTask<Void> gameJar(MinecraftDirectory mcdir, Version version) {
        URI uri = this.getGameJar(version);
        if (uri == null) {
            return null;
        }
        return CombinedDownloadTask.single(new FileDownloadTask(uri, mcdir.getVersionJar(version)).cachePool("org.to2mbn.jmccc.mcdownloader.cache.static.gameJar"));
    }

    @Override
    public CombinedDownloadTask<String> gameVersionJson(MinecraftDirectory mcdir, String version) {
        URI uri = this.getGameVersionJson(version);
        if (uri == null) {
            return null;
        }
        return CombinedDownloadTask.single(new FileDownloadTask(uri, mcdir.getVersionJson(version)).cacheable().cachePool("org.to2mbn.jmccc.mcdownloader.cache.dynamic.versionJson")).andThenReturn(version);
    }

    @Override
    public CombinedDownloadTask<Void> library(MinecraftDirectory mcdir, Library library) {
        URI[] uris = this.getLibrary(library);
        if (uris == null || uris.length == 0) {
            return null;
        }
        return this.library(mcdir, library, uris);
    }

    public CombinedDownloadTask<Void> library(MinecraftDirectory mcdir, Library library, URI ... uris) {
        DownloadTask[] tasks = new DownloadTask[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            URI uri = uris[i];
            String path = uri.getPath();
            LibraryDownloadHandler handler = null;
            for (Map.Entry<String, LibraryDownloadHandler> entry : this.libraryHandlers.entrySet()) {
                if (!path.endsWith(entry.getKey())) continue;
                handler = entry.getValue();
                break;
            }
            if (handler == null) {
                throw new IllegalArgumentException("unable to resolve library download handler, path: " + path);
            }
            tasks[i] = handler.createDownloadTask(mcdir.getLibrary(library), library, uri);
        }
        return CombinedDownloadTask.any(tasks).cachePool("org.to2mbn.jmccc.mcdownloader.cache.static.library");
    }

    @Override
    public CombinedDownloadTask<Void> asset(MinecraftDirectory mcdir, Asset asset) {
        URI uri = this.getAsset(asset);
        if (uri == null) {
            return null;
        }
        return CombinedDownloadTask.single(new FileDownloadTask(uri, mcdir.getAsset(asset)).cachePool("org.to2mbn.jmccc.mcdownloader.cache.static.asset"));
    }

    public void registerLibraryDownloadHandler(String postfix, LibraryDownloadHandler handler) {
        Objects.requireNonNull(postfix);
        Objects.requireNonNull(handler);
        this.libraryHandlers.put(postfix, handler);
    }

    public void unregisterLibraryDownloadHandler(String postfix) {
        this.libraryHandlers.remove(postfix);
    }
}

