/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.to2mbn.jmccc.mcdownloader.provider.DownloadInfoProcessor;
import org.to2mbn.jmccc.mcdownloader.provider.DownloadInfoProvider;
import org.to2mbn.jmccc.mcdownloader.provider.DownloadProviderTree;
import org.to2mbn.jmccc.mcdownloader.provider.ExtendedDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.MojangDownloadProvider;
import org.to2mbn.jmccc.util.Builder;

public class DownloadProviderChain
implements Builder<MinecraftDownloadProvider> {
    protected MinecraftDownloadProvider baseProvider;
    protected List<MinecraftDownloadProvider> providers = new ArrayList<MinecraftDownloadProvider>();
    protected List<Builder<MinecraftDownloadProvider>> aheadProviders = new ArrayList<Builder<MinecraftDownloadProvider>>();
    protected boolean useDownloadInfo = true;
    protected List<DownloadInfoProcessor> downloadInfoProcessor = new ArrayList<DownloadInfoProcessor>();

    protected DownloadProviderChain() {
    }

    public static DownloadProviderChain create() {
        return new DownloadProviderChain();
    }

    public static MinecraftDownloadProvider buildDefault() {
        return DownloadProviderChain.create().build();
    }

    public DownloadProviderChain baseProvider(MinecraftDownloadProvider baseProvider) {
        this.baseProvider = baseProvider;
        return this;
    }

    public DownloadProviderChain addProvider(MinecraftDownloadProvider provider) {
        this.providers.add(Objects.requireNonNull(provider));
        return this;
    }

    public DownloadProviderChain addAheadProvider(Builder<MinecraftDownloadProvider> aheadProvider) {
        this.aheadProviders.add(Objects.requireNonNull(aheadProvider));
        return this;
    }

    public DownloadProviderChain useDownloadInfo(boolean useDownloadInfo) {
        this.useDownloadInfo = useDownloadInfo;
        return this;
    }

    public DownloadProviderChain addDownloadInfoProcessor(DownloadInfoProcessor processor) {
        this.downloadInfoProcessor.add(Objects.requireNonNull(processor));
        return this;
    }

    @Override
    public MinecraftDownloadProvider build() {
        MinecraftDownloadProvider right = this.baseProvider == null ? new MojangDownloadProvider() : this.baseProvider;
        for (MinecraftDownloadProvider left : this.providers) {
            if (left instanceof ExtendedDownloadProvider) {
                ((ExtendedDownloadProvider)left).setUpstreamProvider(this.withAheadProvider(right));
            }
            right = new DownloadProviderTree(left, right);
        }
        right = this.withAheadProvider(right);
        return right;
    }

    protected MinecraftDownloadProvider withAheadProvider(MinecraftDownloadProvider right) {
        ArrayList<MinecraftDownloadProvider> ahead = new ArrayList<MinecraftDownloadProvider>();
        for (Builder<MinecraftDownloadProvider> builder : this.aheadProviders) {
            ahead.add(Objects.requireNonNull(builder.build(), "Ahead provider builder [" + builder + "] returns null"));
        }
        if (this.useDownloadInfo) {
            ahead.add(new DownloadInfoProvider(new ArrayList<DownloadInfoProcessor>(this.downloadInfoProcessor)));
        }
        for (MinecraftDownloadProvider left : ahead) {
            if (left instanceof ExtendedDownloadProvider) {
                ((ExtendedDownloadProvider)left).setUpstreamProvider(right);
            }
            right = new DownloadProviderTree(left, right);
        }
        return right;
    }
}

