/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.provider;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.to2mbn.jmccc.mcdownloader.RemoteVersion;
import org.to2mbn.jmccc.mcdownloader.RemoteVersionList;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.FileDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.ResultProcessor;
import org.to2mbn.jmccc.mcdownloader.provider.AbstractMinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.DownloadInfoProcessor;
import org.to2mbn.jmccc.mcdownloader.provider.ExtendedDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.util.ChecksumUtils;
import org.to2mbn.jmccc.version.Asset;
import org.to2mbn.jmccc.version.DownloadInfo;
import org.to2mbn.jmccc.version.Library;
import org.to2mbn.jmccc.version.LibraryInfo;
import org.to2mbn.jmccc.version.Version;
import org.to2mbn.jmccc.version.parsing.Versions;

class DownloadInfoProvider
extends AbstractMinecraftDownloadProvider
implements ExtendedDownloadProvider {
    private List<DownloadInfoProcessor> urlProcessors;
    private MinecraftDownloadProvider upstreamProvider;

    public DownloadInfoProvider(List<DownloadInfoProcessor> urlProcessors) {
        this.urlProcessors = urlProcessors;
    }

    @Override
    public CombinedDownloadTask<Set<Asset>> assetsIndex(final MinecraftDirectory mcdir, final Version version) {
        CombinedDownloadTask<Void> task = this.download(version.getAssetIndexDownloadInfo(), mcdir.getAssetIndex(version), "org.to2mbn.jmccc.mcdownloader.cache.static.assetsIndex");
        if (task != null) {
            return task.andThen(new ResultProcessor<Void, Set<Asset>>(){

                @Override
                public Set<Asset> process(Void arg) throws Exception {
                    return Versions.resolveAssets(mcdir, version);
                }
            });
        }
        return null;
    }

    @Override
    public CombinedDownloadTask<Void> gameJar(MinecraftDirectory mcdir, Version version) {
        Map<String, DownloadInfo> downloads = version.getDownloads();
        if (downloads != null) {
            return this.download(downloads.get("client"), mcdir.getVersionJar(version), "org.to2mbn.jmccc.mcdownloader.cache.static.gameJar");
        }
        return null;
    }

    @Override
    public CombinedDownloadTask<Void> library(MinecraftDirectory mcdir, Library library) {
        LibraryInfo info = library.getDownloadInfo();
        if (info != null) {
            return this.download(info, mcdir.getLibrary(library), "org.to2mbn.jmccc.mcdownloader.cache.static.library");
        }
        return null;
    }

    @Override
    public CombinedDownloadTask<String> gameVersionJson(final MinecraftDirectory mcdir, final String version) {
        if (this.upstreamProvider == null) {
            return null;
        }
        return this.upstreamProvider.versionList().andThenDownload(new ResultProcessor<RemoteVersionList, CombinedDownloadTask<String>>(){

            @Override
            public CombinedDownloadTask<String> process(RemoteVersionList result) throws Exception {
                RemoteVersion remoteVersion = result.getVersions().get(version);
                if (remoteVersion != null && remoteVersion.getUrl() != null) {
                    return CombinedDownloadTask.single(new FileDownloadTask(DownloadInfoProvider.this.parseURI(remoteVersion.getUrl()), mcdir.getVersionJson(remoteVersion.getVersion())).cacheable().cachePool("org.to2mbn.jmccc.mcdownloader.cache.dynamic.versionJson")).andThenReturn(remoteVersion.getVersion());
                }
                return DownloadInfoProvider.this.upstreamProvider.gameVersionJson(mcdir, version);
            }
        });
    }

    @Override
    public void setUpstreamProvider(MinecraftDownloadProvider upstreamProvider) {
        this.upstreamProvider = upstreamProvider;
    }

    private CombinedDownloadTask<Void> download(final DownloadInfo info, final File target, String cachePool) {
        if (info == null || info.getUrl() == null) {
            return null;
        }
        return CombinedDownloadTask.single(new FileDownloadTask(this.parseURI(info.getUrl()), target).andThen(new ResultProcessor<Void, Void>(){

            @Override
            public Void process(Void arg) throws Exception {
                if (!ChecksumUtils.verify(target, info.getChecksum(), "SHA-1", info.getSize())) {
                    throw new IOException("checksums mismatch");
                }
                return null;
            }
        }).cachePool(cachePool));
    }

    private URI parseURI(String str) {
        for (DownloadInfoProcessor urlProcessor : this.urlProcessors) {
            str = urlProcessor.process(str);
        }
        return URI.create(str);
    }
}

