/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.tasks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadSession;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadTask;

public class MemoryDownloadTask
extends DownloadTask<byte[]> {
    public MemoryDownloadTask(String uri) {
        super(uri);
    }

    public MemoryDownloadTask(URI uri) {
        super(uri);
    }

    @Override
    public DownloadSession<byte[]> createSession(final long length) throws IOException {
        return new DownloadSession<byte[]>(){
            private ByteArrayOutputStream out;
            private WritableByteChannel channel;
            {
                this.out = new ByteArrayOutputStream(length == -1L ? 8192 : (int)length);
                this.channel = Channels.newChannel(this.out);
            }

            @Override
            public void receiveData(ByteBuffer data) throws IOException {
                this.channel.write(data);
            }

            @Override
            public void failed() throws IOException {
                this.close();
            }

            @Override
            public byte[] completed() throws IOException {
                byte[] data = this.out.toByteArray();
                this.close();
                return data;
            }

            private void close() {
                this.channel = null;
                this.out = null;
            }
        };
    }

    @Override
    public DownloadSession<byte[]> createSession() throws IOException {
        return this.createSession(8192L);
    }
}

