/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadSession;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadTask;
import org.to2mbn.jmccc.util.FileUtils;

public class FileDownloadTask
extends DownloadTask<Void> {
    private File target;

    public FileDownloadTask(String uri, File target) {
        super(uri);
        Objects.requireNonNull(target);
        this.target = target;
    }

    public FileDownloadTask(URI uri, File target) {
        super(uri);
        Objects.requireNonNull(target);
        this.target = target;
    }

    public File getTarget() {
        return this.target;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.target);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (super.equals(obj)) {
            FileDownloadTask another = (FileDownloadTask)obj;
            return this.target.equals(another.target);
        }
        return false;
    }

    @Override
    public DownloadSession<Void> createSession() throws IOException {
        final File partFile = new File(this.target.getParentFile(), this.target.getName() + ".part");
        FileUtils.prepareWrite(partFile);
        final FileOutputStream out = new FileOutputStream(partFile);
        final FileChannel channel = out.getChannel();
        return new DownloadSession<Void>(){

            @Override
            public void receiveData(ByteBuffer data) throws IOException {
                channel.write(data);
            }

            @Override
            public void failed() throws IOException {
                this.close();
                if (!partFile.delete()) {
                    throw new IOException("Failed to delete " + partFile);
                }
            }

            @Override
            public Void completed() throws IOException {
                this.close();
                FileUtils.prepareWrite(FileDownloadTask.this.target);
                if (FileDownloadTask.this.target.exists() && !FileDownloadTask.this.target.delete()) {
                    throw new IOException("Failed to delete " + FileDownloadTask.this.target);
                }
                if (!partFile.renameTo(FileDownloadTask.this.target)) {
                    throw new IOException("Failed to rename " + partFile + " to " + FileDownloadTask.this.target);
                }
                return null;
            }

            private void close() throws IOException {
                out.close();
            }
        };
    }
}

