/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.io.async;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeader;
import org.to2mbn.jmccc.mcdownloader.download.Downloader;
import org.to2mbn.jmccc.mcdownloader.download.io.AbstractDownloaderBuilder;
import org.to2mbn.jmccc.mcdownloader.download.io.async.HttpAsyncDownloader;
import org.to2mbn.jmccc.mcdownloader.util.ThreadPoolUtils;
import org.to2mbn.jmccc.util.Builder;

public class HttpAsyncDownloaderBuilder
extends AbstractDownloaderBuilder {
    protected Builder<CloseableHttpAsyncClient> httpClient;
    protected int bootstrapPoolSize = Runtime.getRuntime().availableProcessors();

    public static boolean isAvailable() {
        try {
            Class.forName("org.apache.http.impl.nio.client.HttpAsyncClientBuilder");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static HttpAsyncDownloaderBuilder create() {
        return new HttpAsyncDownloaderBuilder();
    }

    public static Downloader buildDefault() {
        return HttpAsyncDownloaderBuilder.create().build();
    }

    private static HttpHost resolveProxy(Proxy proxy) {
        SocketAddress socketAddress;
        if (proxy.type() == Proxy.Type.DIRECT) {
            return null;
        }
        if (proxy.type() == Proxy.Type.HTTP && (socketAddress = proxy.address()) instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return new HttpHost(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        throw new IllegalArgumentException("Proxy '" + proxy + "' is not supported");
    }

    public HttpAsyncDownloaderBuilder httpClient(Builder<CloseableHttpAsyncClient> httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public HttpAsyncDownloaderBuilder httpClient(HttpAsyncClientBuilder httpClient) {
        this.httpClient = httpClient == null ? null : new HttpAsyncClientBuilderAdapter(httpClient);
        return this;
    }

    public HttpAsyncDownloaderBuilder bootstrapPoolSize(int bootstrapPoolSize) {
        this.bootstrapPoolSize = bootstrapPoolSize;
        return this;
    }

    @Override
    public Downloader build() {
        CloseableHttpAsyncClient client = null;
        ExecutorService pool = null;
        try {
            client = this.httpClient == null ? this.buildDefaultHttpAsyncClient() : this.httpClient.build();
            pool = ThreadPoolUtils.createPool(this.bootstrapPoolSize, this.downloadPoolKeepAliveTime, this.downloadPoolKeepAliveTimeUnit, "asyncDownloader.bootstrap");
            return new HttpAsyncDownloader(client, pool);
        }
        catch (Throwable e) {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            if (pool != null) {
                try {
                    pool.shutdownNow();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            throw e;
        }
    }

    protected CloseableHttpAsyncClient buildDefaultHttpAsyncClient() {
        HttpHost httpProxy = HttpAsyncDownloaderBuilder.resolveProxy(this.proxy);
        return HttpAsyncClientBuilder.create().setMaxConnTotal(this.maxConnections).setMaxConnPerRoute(this.maxConnections).setProxy(httpProxy).setDefaultIOReactorConfig(IOReactorConfig.custom().setConnectTimeout(this.connectTimeout).setSoTimeout(this.readTimeout).build()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.readTimeout).setProxy(httpProxy).build()).setDefaultHeaders(Arrays.asList(new BasicHeader("Accept-Encoding", "gzip"))).build();
    }

    private static class HttpAsyncClientBuilderAdapter
    implements Builder<CloseableHttpAsyncClient> {
        private HttpAsyncClientBuilder adapted;

        public HttpAsyncClientBuilderAdapter(HttpAsyncClientBuilder adapted) {
            this.adapted = adapted;
        }

        @Override
        public CloseableHttpAsyncClient build() {
            return this.adapted.build();
        }
    }
}

