/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.combine;

import java.util.concurrent.Future;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadContext;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadContextDecorator;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.CombinedDownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.DownloadCallback;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadTask;

class DownloadContextCacheStrategyDecorator<T>
extends CombinedDownloadContextDecorator<T> {
    private CombinedDownloadTask.CacheStrategy strategy;

    public DownloadContextCacheStrategyDecorator(CombinedDownloadContext<T> delegated, CombinedDownloadTask.CacheStrategy strategy) {
        super(delegated);
        this.strategy = strategy;
    }

    @Override
    public <R> Future<R> submit(DownloadTask<R> task, DownloadCallback<R> callback, boolean fatal) throws InterruptedException {
        DownloadTask<R> processed;
        switch (this.strategy) {
            case CACHEABLE: 
            case FORCIBLY_CACHE: {
                processed = task.cacheable(true);
                break;
            }
            case NON_CACHEABLE: {
                processed = task.cacheable(false);
                break;
            }
            default: {
                processed = task;
            }
        }
        return this.delegated.submit(processed, callback, fatal);
    }

    @Override
    public <R> Future<R> submit(CombinedDownloadTask<R> task, CombinedDownloadCallback<R> callback, boolean fatal) throws InterruptedException {
        CombinedDownloadTask<R> processed;
        switch (this.strategy) {
            case CACHEABLE: {
                if (task.getCacheStrategy() == CombinedDownloadTask.CacheStrategy.DEFAULT) {
                    processed = task.cacheable(CombinedDownloadTask.CacheStrategy.CACHEABLE);
                    break;
                }
                processed = task;
                break;
            }
            case FORCIBLY_CACHE: 
            case NON_CACHEABLE: {
                processed = task.cacheable(this.strategy);
                break;
            }
            default: {
                processed = task;
            }
        }
        return this.delegated.submit(processed, callback, fatal);
    }
}

