/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.combine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.to2mbn.jmccc.mcdownloader.download.combine.AndThenCombinedTask;
import org.to2mbn.jmccc.mcdownloader.download.combine.AndThenDownloadCombinedTask;
import org.to2mbn.jmccc.mcdownloader.download.combine.AnyCombinedTask;
import org.to2mbn.jmccc.mcdownloader.download.combine.BlockedMultipleCombinedTask;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadContext;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedTaskCachePoolDecorator;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedTaskCacheStrategyDecorator;
import org.to2mbn.jmccc.mcdownloader.download.combine.MultipleCombinedTask;
import org.to2mbn.jmccc.mcdownloader.download.combine.SingleCombinedTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.DownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.tasks.ResultProcessor;

public abstract class CombinedDownloadTask<T> {
    public static <T> CombinedDownloadTask<T> single(DownloadTask<T> task) {
        Objects.requireNonNull(task);
        return new SingleCombinedTask<T>(task);
    }

    public static CombinedDownloadTask<Void> multiple(DownloadTask<?> ... tasks) {
        Objects.requireNonNull(tasks);
        CombinedDownloadTask[] combinedTasks = new CombinedDownloadTask[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            combinedTasks[i] = CombinedDownloadTask.single(tasks[i]);
        }
        return CombinedDownloadTask.multiple(combinedTasks);
    }

    public static CombinedDownloadTask<Void> multiple(CombinedDownloadTask<?> ... tasks) {
        Objects.requireNonNull(tasks);
        return new MultipleCombinedTask(tasks);
    }

    public static CombinedDownloadTask<Object[]> all(DownloadTask<?> ... tasks) {
        Objects.requireNonNull(tasks);
        ArrayList combinedTasks = new ArrayList(tasks.length);
        for (DownloadTask<?> task : tasks) {
            combinedTasks.add(CombinedDownloadTask.single(task));
        }
        return new BlockedMultipleCombinedTask(combinedTasks);
    }

    public static CombinedDownloadTask<Object[]> all(CombinedDownloadTask<?> ... tasks) {
        Objects.requireNonNull(tasks);
        return new BlockedMultipleCombinedTask(Arrays.asList(tasks));
    }

    @SafeVarargs
    public static <T> CombinedDownloadTask<T> any(DownloadTask<T> ... tasks) {
        Objects.requireNonNull(tasks);
        CombinedDownloadTask[] combinedTasks = new CombinedDownloadTask[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            combinedTasks[i] = CombinedDownloadTask.single(tasks[i]);
        }
        return CombinedDownloadTask.any(combinedTasks);
    }

    @SafeVarargs
    public static <T> CombinedDownloadTask<T> any(CombinedDownloadTask<T> ... tasks) {
        Objects.requireNonNull(tasks);
        return CombinedDownloadTask.any(new Class[]{IOException.class}, tasks);
    }

    @SafeVarargs
    public static <T> CombinedDownloadTask<T> any(Class<? extends Throwable>[] expectedExceptions, CombinedDownloadTask<T> ... tasks) {
        Objects.requireNonNull(tasks);
        Objects.requireNonNull(expectedExceptions);
        if (tasks.length == 0) {
            throw new IllegalArgumentException("Tasks cannot be empty");
        }
        return new AnyCombinedTask<T>(tasks, expectedExceptions);
    }

    public abstract void execute(CombinedDownloadContext<T> var1) throws Exception;

    public CacheStrategy getCacheStrategy() {
        return CacheStrategy.DEFAULT;
    }

    public String getCachePool() {
        return null;
    }

    public final CombinedDownloadTask<T> cacheable(CacheStrategy strategy) {
        Objects.requireNonNull(strategy);
        if (this.getCacheStrategy() == strategy) {
            return this;
        }
        return new CombinedTaskCacheStrategyDecorator(this, strategy);
    }

    public final CombinedDownloadTask<T> cachePool(String pool) {
        if (Objects.equals(this.getCachePool(), pool)) {
            return this;
        }
        return new CombinedTaskCachePoolDecorator(this, pool);
    }

    public final <R> CombinedDownloadTask<R> andThen(ResultProcessor<T, R> processor) {
        return new AndThenCombinedTask<T, R>(this, processor);
    }

    public final CombinedDownloadTask<T> andThenCall(Consumer<T> callback) {
        return this.andThen(it -> {
            callback.accept(it);
            return it;
        });
    }

    public final <R> CombinedDownloadTask<R> andThenDownload(ResultProcessor<T, CombinedDownloadTask<R>> then) {
        return new AndThenDownloadCombinedTask<T, R>(this, then);
    }

    public final <R> CombinedDownloadTask<R> andThenReturn(R result) {
        return this.andThen(arg -> result);
    }

    public static enum CacheStrategy {
        DEFAULT,
        FORCIBLY_CACHE,
        CACHEABLE,
        NON_CACHEABLE;

    }
}

