/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.combine;

import java.util.concurrent.Callable;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadContext;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.CallbackAdapter;

class AnyCombinedTask<T>
extends CombinedDownloadTask<T> {
    private CombinedDownloadTask<T>[] tasks;
    private Class<? extends Throwable>[] expectedExceptions;

    public AnyCombinedTask(CombinedDownloadTask<T>[] tasks, Class<? extends Throwable>[] expectedExceptions) {
        this.tasks = tasks;
        this.expectedExceptions = expectedExceptions;
    }

    @Override
    public void execute(CombinedDownloadContext<T> context) throws Exception {
        this.executeSubtask(context, 0, null);
    }

    public void executeSubtask(final CombinedDownloadContext<T> context, final int index, final Throwable oldEx) throws InterruptedException {
        CombinedDownloadTask<T> task = this.tasks[index];
        context.submit(task, new CallbackAdapter<T>(){

            @Override
            public void done(T result) {
                context.done(result);
            }

            @Override
            public void failed(final Throwable e) {
                try {
                    context.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            int next;
                            if (oldEx != null) {
                                e.addSuppressed(oldEx);
                            }
                            if ((next = index + 1) < AnyCombinedTask.this.tasks.length && AnyCombinedTask.this.canContinue(e)) {
                                AnyCombinedTask.this.executeSubtask(context, next, e);
                            } else {
                                context.failed(e);
                            }
                            return null;
                        }
                    }, null, true);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }

            @Override
            public void cancelled() {
                context.cancelled();
            }
        }, false);
    }

    private boolean canContinue(Throwable e) {
        for (Class<? extends Throwable> expected : this.expectedExceptions) {
            if (!expected.isInstance(e)) continue;
            return true;
        }
        return false;
    }
}

