/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader.download.cache;

import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.cache.CacheException;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.spi.CachingProvider;
import org.ehcache.CacheManager;
import org.ehcache.Status;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.to2mbn.jmccc.mcdownloader.download.Downloader;
import org.to2mbn.jmccc.mcdownloader.download.cache.CachedDownloader;
import org.to2mbn.jmccc.mcdownloader.download.cache.provider.CacheProvider;
import org.to2mbn.jmccc.mcdownloader.download.cache.provider.EhcacheProvider;
import org.to2mbn.jmccc.mcdownloader.download.cache.provider.JCacheProvider;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Shutdownable;
import org.to2mbn.jmccc.util.Builder;
import org.to2mbn.jmccc.util.Builders;

public class CachedDownloaderBuilder
implements Builder<Downloader> {
    private static final Logger LOGGER = Logger.getLogger(CachedDownloaderBuilder.class.getCanonicalName());
    private static final long DEFAULT_CACHE_TTL = 2L;
    private static final TimeUnit DEFAULT_CACHE_TTL_UNIT = TimeUnit.HOURS;
    private static final long DEFAULT_CACHE_HEAP = 32L;
    private static final String DEFAULT_CACHE_HEAP_UNIT = "MB";
    protected final Builder<Downloader> underlying;
    protected Builder<? extends CacheProvider<URI, byte[]>> cacheProvider;

    protected CachedDownloaderBuilder(Builder<Downloader> underlying) {
        this.underlying = Objects.requireNonNull(underlying);
    }

    public static CachedDownloaderBuilder create(Builder<Downloader> underlying) {
        return new CachedDownloaderBuilder(underlying);
    }

    public static Downloader buildDefault(Builder<Downloader> underlying) {
        return CachedDownloaderBuilder.create(underlying).build();
    }

    public static boolean isAvailable() {
        return JCacheProvider.isAvailable() && JCacheSupport.hasAvailableProvider() || EhcacheProvider.isAvailable();
    }

    public CachedDownloaderBuilder cacheProvider(Builder<? extends CacheProvider<URI, byte[]>> cacheProvider) {
        this.cacheProvider = Objects.requireNonNull(cacheProvider);
        return this;
    }

    public CachedDownloaderBuilder ehcache(Builder<? extends CacheManager> ehcache, boolean autoClose) {
        this.cacheProvider = new EhcacheProviderBuilder(Objects.requireNonNull(ehcache), autoClose);
        return this;
    }

    public CachedDownloaderBuilder ehcache(Builder<? extends CacheManager> ehcache) {
        return this.ehcache(ehcache, true);
    }

    public CachedDownloaderBuilder ehcache(org.ehcache.config.Builder<? extends CacheManager> ehcache, boolean autoClose) {
        return this.ehcache(new EhcacheBuilderAdapter<CacheManager>(Objects.requireNonNull(ehcache)), autoClose);
    }

    public CachedDownloaderBuilder ehcache(org.ehcache.config.Builder<? extends CacheManager> ehcache) {
        return this.ehcache(ehcache, true);
    }

    public CachedDownloaderBuilder ehcache(CacheManager ehcache, boolean autoClose) {
        Objects.requireNonNull(ehcache);
        return this.ehcache(Builders.of(ehcache), autoClose);
    }

    public CachedDownloaderBuilder ehcache(CacheManager ehcache) {
        return this.ehcache(ehcache, false);
    }

    public CachedDownloaderBuilder jcache(Builder<? extends javax.cache.CacheManager> jcache, boolean autoClose) {
        this.cacheProvider = new JCacheProviderBuilder(Objects.requireNonNull(jcache), autoClose);
        return this;
    }

    public CachedDownloaderBuilder jcache(Builder<? extends javax.cache.CacheManager> jcache) {
        return this.jcache(jcache, true);
    }

    public CachedDownloaderBuilder jcache(javax.cache.CacheManager jcache, boolean autoClose) {
        Objects.requireNonNull(jcache);
        this.cacheProvider = new JCacheProviderBuilder(Builders.of(jcache), autoClose);
        return this;
    }

    public CachedDownloaderBuilder jcache(javax.cache.CacheManager jcache) {
        return this.jcache(jcache, false);
    }

    @Override
    public Downloader build() {
        Shutdownable underlying = null;
        CacheProvider<URI, byte[]> cache = null;
        try {
            underlying = Objects.requireNonNull(this.underlying.build(), "Underlying downloader builder returns null");
            cache = this.buildCacheProvider();
            LOGGER.fine("Using cache provider: " + cache);
            return new CachedDownloader((Downloader)underlying, cache);
        }
        catch (Throwable e) {
            if (underlying != null) {
                try {
                    underlying.shutdown();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            if (cache != null) {
                try {
                    cache.close();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            throw e;
        }
    }

    private CacheProvider<URI, byte[]> buildCacheProvider() {
        CacheProvider<URI, byte[]> provider;
        if (this.cacheProvider == null) {
            provider = this.createDefaultCacheProvider();
            if (provider == null) {
                throw new IllegalStateException("No default cache provider found");
            }
        } else {
            provider = Objects.requireNonNull(this.cacheProvider.build(), "Cache provider builder returns null");
        }
        return provider;
    }

    protected CacheProvider<URI, byte[]> createDefaultCacheProvider() {
        CacheProvider<URI, byte[]> provider = null;
        if (JCacheProvider.isAvailable()) {
            provider = JCacheSupport.createDefault();
        }
        if (provider == null && EhcacheProvider.isAvailable()) {
            provider = EhcacheSupport.createDefault();
        }
        return provider;
    }

    private static class JCacheSupport {
        private JCacheSupport() {
        }

        static CacheProvider<URI, byte[]> adapt(javax.cache.CacheManager manager, boolean autoClose) {
            return new JCacheProvider<URI, byte[]>(manager, URI.class, byte[].class, autoClose);
        }

        static javax.cache.CacheManager defaultCacheManager() {
            CachingProvider cachingProvider;
            try {
                cachingProvider = Caching.getCachingProvider();
            }
            catch (CacheException e) {
                return null;
            }
            javax.cache.CacheManager cacheManager = cachingProvider.getCacheManager();
            if (cacheManager.getCache("org.to2mbn.jmccc.mcdownloader.cache.default", URI.class, byte[].class) == null) {
                cacheManager.createCache("org.to2mbn.jmccc.mcdownloader.cache.default", new MutableConfiguration<URI, byte[]>().setTypes(URI.class, byte[].class).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf(new javax.cache.expiry.Duration(DEFAULT_CACHE_TTL_UNIT, 2L))));
            }
            return cacheManager;
        }

        static CacheProvider<URI, byte[]> createDefault() {
            javax.cache.CacheManager cacheManager = JCacheSupport.defaultCacheManager();
            if (cacheManager == null) {
                return null;
            }
            return JCacheSupport.adapt(cacheManager, true);
        }

        static boolean hasAvailableProvider() {
            return Caching.getCachingProviders().iterator().hasNext();
        }
    }

    private static class EhcacheProviderBuilder
    implements Builder<CacheProvider<URI, byte[]>> {
        private Builder<? extends CacheManager> ehcache;
        private boolean autoClose;

        public EhcacheProviderBuilder(Builder<? extends CacheManager> ehcache, boolean autoClose) {
            this.ehcache = ehcache;
            this.autoClose = autoClose;
        }

        @Override
        public CacheProvider<URI, byte[]> build() {
            return EhcacheSupport.adapt(this.ehcache.build(), this.autoClose);
        }
    }

    private static class EhcacheBuilderAdapter<T>
    implements Builder<T> {
        private org.ehcache.config.Builder<T> adapted;

        public EhcacheBuilderAdapter(org.ehcache.config.Builder<T> adapted) {
            this.adapted = adapted;
        }

        @Override
        public T build() {
            return this.adapted.build();
        }
    }

    private static class JCacheProviderBuilder
    implements Builder<CacheProvider<URI, byte[]>> {
        private Builder<? extends javax.cache.CacheManager> jcache;
        private boolean autoClose;

        public JCacheProviderBuilder(Builder<? extends javax.cache.CacheManager> jcache, boolean autoClose) {
            this.jcache = jcache;
            this.autoClose = autoClose;
        }

        @Override
        public CacheProvider<URI, byte[]> build() {
            return JCacheSupport.adapt(this.jcache.build(), this.autoClose);
        }
    }

    private static class EhcacheSupport {
        private EhcacheSupport() {
        }

        static CacheProvider<URI, byte[]> adapt(CacheManager manager, boolean autoClose) {
            if (manager.getStatus() == Status.UNINITIALIZED) {
                manager.init();
            }
            return new EhcacheProvider<URI, byte[]>(manager, URI.class, byte[].class, autoClose);
        }

        static org.ehcache.config.Builder<CacheManager> defaultCacheManagerBuilder() {
            return CacheManagerBuilder.newCacheManagerBuilder().withCache("org.to2mbn.jmccc.mcdownloader.cache.default", CacheConfigurationBuilder.newCacheConfigurationBuilder(URI.class, byte[].class, ResourcePoolsBuilder.newResourcePoolsBuilder().heap(32L, MemoryUnit.valueOf(CachedDownloaderBuilder.DEFAULT_CACHE_HEAP_UNIT))).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration(Duration.ofSeconds(DEFAULT_CACHE_TTL_UNIT.toSeconds(2L)))));
        }

        static CacheProvider<URI, byte[]> createDefault() {
            return EhcacheSupport.adapt(EhcacheSupport.defaultCacheManagerBuilder().build(), true);
        }
    }
}

