/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.to2mbn.jmccc.internal.org.json.JSONException;
import org.to2mbn.jmccc.internal.org.json.JSONObject;

public class RemoteVersion
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(RemoteVersion.class.getCanonicalName());
    private static final Pattern DATETIME_PATTERN = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2})([+\\-]\\d{2}:?\\d{2})?$");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final long serialVersionUID = 1L;
    private String version;
    private Date uploadTime;
    private String uploadTimeString;
    private Date releaseTime;
    private String releaseTimeString;
    private String type;
    private String url;

    public RemoteVersion(String version, Date uploadTime, String uploadTimeString, Date releaseTime, String releaseTimeString, String type, String url) {
        this.version = Objects.requireNonNull(version);
        this.uploadTime = uploadTime;
        this.uploadTimeString = uploadTimeString;
        this.releaseTime = releaseTime;
        this.releaseTimeString = releaseTimeString;
        this.type = type;
        this.url = url;
    }

    public static RemoteVersion fromJson(JSONObject json) throws JSONException {
        String version = json.getString("id");
        String updateTime = json.optString("time", null);
        String releaseTime = json.optString("releaseTime", null);
        String type = json.optString("type", null);
        String url = json.optString("url", null);
        return new RemoteVersion(version, updateTime == null ? null : RemoteVersion.convertDate(updateTime), updateTime, releaseTime == null ? null : RemoteVersion.convertDate(releaseTime), releaseTime, type, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date convertDate(String date) {
        try {
            Date localdatetime;
            Matcher matcher = DATETIME_PATTERN.matcher(date);
            if (!matcher.find()) {
                throw new IllegalArgumentException("regex mismatch");
            }
            String datetime = matcher.group(1);
            String timezoneoffset = matcher.group(2).replace(":", "");
            boolean negativeoffset = timezoneoffset.charAt(0) == '-';
            int offsetsecs = Integer.parseInt(timezoneoffset.substring(1, 3)) * 3600 + Integer.parseInt(timezoneoffset.substring(3, 5));
            if (negativeoffset) {
                offsetsecs = -offsetsecs;
            }
            SimpleDateFormat simpleDateFormat = DATE_FORMAT;
            synchronized (simpleDateFormat) {
                localdatetime = DATE_FORMAT.parse(datetime);
            }
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.setTime(localdatetime);
            cal.add(13, -offsetsecs);
            return cal.getTime();
        }
        catch (IllegalArgumentException | ParseException e) {
            LOGGER.log(Level.WARNING, "Couldn't parse date, skipping: " + date, e);
            return null;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public Date getUploadTime() {
        return this.uploadTime;
    }

    public Date getReleaseTime() {
        return this.releaseTime;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUploadTimeString() {
        return this.uploadTimeString;
    }

    public String getReleaseTimeString() {
        return this.releaseTimeString;
    }

    public String toString() {
        return String.format("RemoteVersion [version=%s, uploadTime=%s, uploadTimeString=%s, releaseTime=%s, releaseTimeString=%s, type=%s, url=%s]", this.version, this.uploadTime, this.uploadTimeString, this.releaseTime, this.releaseTimeString, this.type, this.url);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RemoteVersion) {
            RemoteVersion another = (RemoteVersion)obj;
            return Objects.equals(this.version, another.version) && Objects.equals(this.releaseTime, another.releaseTime) && Objects.equals(this.releaseTimeString, another.releaseTimeString) && Objects.equals(this.uploadTime, another.uploadTime) && Objects.equals(this.uploadTimeString, another.uploadTimeString) && Objects.equals(this.type, another.type) && Objects.equals(this.url, another.url);
        }
        return false;
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

