/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader;

import java.util.Objects;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloader;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloaderImpl;
import org.to2mbn.jmccc.mcdownloader.download.Downloader;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloader;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloaderBuilder;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.Shutdownable;
import org.to2mbn.jmccc.mcdownloader.provider.DownloadProviderChain;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.util.Builder;
import org.to2mbn.jmccc.util.Builders;

public class MinecraftDownloaderBuilder
implements Builder<MinecraftDownloader> {
    protected final Builder<? extends Downloader> underlying;
    protected Builder<MinecraftDownloadProvider> providerChain;

    protected MinecraftDownloaderBuilder(Builder<? extends Downloader> underlying) {
        this.underlying = underlying;
    }

    public static MinecraftDownloaderBuilder create(Builder<? extends Downloader> underlying) {
        return new MinecraftDownloaderBuilder(underlying);
    }

    public static MinecraftDownloaderBuilder create() {
        return MinecraftDownloaderBuilder.create(CombinedDownloaderBuilder.create());
    }

    public static MinecraftDownloader buildDefault(Builder<? extends Downloader> underlying) {
        return new MinecraftDownloaderBuilder(underlying).build();
    }

    public static MinecraftDownloader buildDefault() {
        return MinecraftDownloaderBuilder.buildDefault(CombinedDownloaderBuilder.create());
    }

    public MinecraftDownloaderBuilder providerChain(Builder<MinecraftDownloadProvider> providerChain) {
        this.providerChain = providerChain;
        return this;
    }

    @Override
    public MinecraftDownloader build() {
        MinecraftDownloadProvider provider = this.providerChain == null ? DownloadProviderChain.buildDefault() : Objects.requireNonNull(this.providerChain.build(), "providerChain builder returns null");
        Shutdownable combinedDownloader = null;
        Downloader underlying = null;
        try {
            underlying = Objects.requireNonNull(this.underlying.build(), "Underlying downloader builder returns null");
            combinedDownloader = underlying instanceof CombinedDownloader ? (CombinedDownloader)underlying : CombinedDownloaderBuilder.buildDefault(Builders.of(underlying));
            return new MinecraftDownloaderImpl((CombinedDownloader)combinedDownloader, provider);
        }
        catch (Throwable e) {
            if (combinedDownloader != null) {
                try {
                    combinedDownloader.shutdown();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            if (underlying != null) {
                try {
                    underlying.shutdown();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            throw e;
        }
    }
}

