/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.mcdownloader;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.mcdownloader.AssetOption;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadContext;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.download.concurrent.CallbackAdapter;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.util.ChecksumUtils;
import org.to2mbn.jmccc.util.IOUtils;
import org.to2mbn.jmccc.version.Asset;
import org.to2mbn.jmccc.version.DownloadInfo;
import org.to2mbn.jmccc.version.Library;
import org.to2mbn.jmccc.version.Version;
import org.to2mbn.jmccc.version.parsing.Versions;

class IncrementallyDownloadTask
extends CombinedDownloadTask<Version> {
    private MinecraftDirectory mcdir;
    private String version;
    private MinecraftDownloadProvider provider;
    private boolean checkLibrariesHash;
    private boolean checkAssetsHash;
    private boolean updateSnapshots;
    private AssetOption assetOption;
    private Set<String> handledVersions = Collections.newSetFromMap(new ConcurrentHashMap());
    private String resolvedVersion;

    public IncrementallyDownloadTask(MinecraftDownloadProvider downloadProvider, MinecraftDirectory mcdir, String version, boolean checkLibrariesHash, boolean checkAssetsHash, boolean updateSnapshots, AssetOption assetOption) {
        Objects.requireNonNull(mcdir);
        Objects.requireNonNull(version);
        Objects.requireNonNull(downloadProvider);
        this.mcdir = mcdir;
        this.version = version;
        this.provider = downloadProvider;
        this.checkLibrariesHash = checkLibrariesHash;
        this.checkAssetsHash = checkAssetsHash;
        this.updateSnapshots = updateSnapshots;
        this.assetOption = assetOption;
    }

    @Override
    public void execute(final CombinedDownloadContext<Version> context) throws Exception {
        this.handledVersions.clear();
        this.resolvedVersion = null;
        this.handleVersionJson(this.version, context, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (IncrementallyDownloadTask.this.resolvedVersion == null) {
                    IncrementallyDownloadTask.this.resolvedVersion = IncrementallyDownloadTask.this.version;
                }
                final Version versionModel = Versions.resolveVersion(IncrementallyDownloadTask.this.mcdir, IncrementallyDownloadTask.this.resolvedVersion);
                if (IncrementallyDownloadTask.this.mcdir.getAssetIndex(versionModel).exists()) {
                    IncrementallyDownloadTask.this.downloadAssets(context, Versions.resolveAssets(IncrementallyDownloadTask.this.mcdir, versionModel));
                } else {
                    context.submit(IncrementallyDownloadTask.this.provider.assetsIndex(IncrementallyDownloadTask.this.mcdir, versionModel), new CallbackAdapter<Set<Asset>>(){

                        @Override
                        public void done(final Set<Asset> result) {
                            try {
                                context.submit(new Callable<Void>(){

                                    @Override
                                    public Void call() throws Exception {
                                        IncrementallyDownloadTask.this.downloadAssets(context, result);
                                        return null;
                                    }
                                }, null, true);
                            }
                            catch (InterruptedException e) {
                                context.cancelled();
                            }
                        }
                    }, true);
                }
                if (!IncrementallyDownloadTask.this.mcdir.getVersionJar(versionModel).exists()) {
                    context.submit(IncrementallyDownloadTask.this.provider.gameJar(IncrementallyDownloadTask.this.mcdir, versionModel), null, true);
                }
                IncrementallyDownloadTask.this.downloadLibraries(context, versionModel);
                context.awaitAllTasks(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        context.done(versionModel);
                        return null;
                    }
                });
                return null;
            }
        });
    }

    private void handleVersionJson(final String currentVersion, final CombinedDownloadContext<Version> context, final Callable<Void> callback) throws Exception {
        if (this.mcdir.getVersionJson(currentVersion).exists()) {
            JSONObject versionjson = IOUtils.toJson(this.mcdir.getVersionJson(currentVersion));
            String inheritsFrom = versionjson.optString("inheritsFrom", null);
            this.handledVersions.add(currentVersion);
            if (inheritsFrom == null) {
                callback.call();
            } else {
                if (this.handledVersions.contains(inheritsFrom)) {
                    throw new IllegalStateException("loop inherits from: " + currentVersion + " to " + inheritsFrom);
                }
                this.handleVersionJson(inheritsFrom, context, callback);
            }
        } else {
            context.submit(this.provider.gameVersionJson(this.mcdir, currentVersion), new CallbackAdapter<String>(){

                @Override
                public void done(final String currentResolvedVersion) {
                    try {
                        context.submit(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                if (IncrementallyDownloadTask.this.version.equals(currentVersion)) {
                                    IncrementallyDownloadTask.this.resolvedVersion = currentResolvedVersion;
                                }
                                IncrementallyDownloadTask.this.handleVersionJson(currentResolvedVersion, context, callback);
                                return null;
                            }
                        }, null, true);
                    }
                    catch (InterruptedException e) {
                        context.cancelled();
                    }
                }
            }, true);
        }
    }

    private void downloadAssets(final CombinedDownloadContext<Version> context, Set<Asset> assets) throws InterruptedException {
        boolean fatal;
        if (assets == null || this.assetOption == AssetOption.SKIP_ASSETS) {
            return;
        }
        HashMap<String, Asset> hashMapping = new HashMap<String, Asset>();
        for (Asset asset : assets) {
            hashMapping.put(asset.getHash(), asset);
        }
        boolean bl = fatal = this.assetOption == AssetOption.FORCIBLY_DOWNLOAD;
        if (this.checkAssetsHash) {
            for (final Asset asset : hashMapping.values()) {
                context.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (!asset.isValid(IncrementallyDownloadTask.this.mcdir)) {
                            context.submit(IncrementallyDownloadTask.this.provider.asset(IncrementallyDownloadTask.this.mcdir, asset), null, fatal);
                        }
                        return null;
                    }
                }, null, false);
            }
        } else {
            for (Asset asset : hashMapping.values()) {
                if (this.mcdir.getAsset(asset).isFile()) continue;
                context.submit(this.provider.asset(this.mcdir, asset), null, fatal);
            }
        }
    }

    private void downloadLibraries(final CombinedDownloadContext<?> context, Version version) throws InterruptedException {
        if (this.checkLibrariesHash) {
            for (final Library library : version.getLibraries()) {
                context.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (IncrementallyDownloadTask.this.needDownload(IncrementallyDownloadTask.this.mcdir.getLibrary(library), library.getDownloadInfo())) {
                            IncrementallyDownloadTask.this.downloadLibrary(context, library, true);
                        } else {
                            IncrementallyDownloadTask.this.checkAndUpdate(context, library);
                        }
                        return null;
                    }
                }, null, true);
            }
        } else {
            Set<Library> missing = version.getMissingLibraries(this.mcdir);
            for (Library library : missing) {
                this.downloadLibrary(context, library, true);
            }
            HashSet<Library> existing = new HashSet<Library>(version.getLibraries());
            existing.removeAll(missing);
            for (Library library : existing) {
                this.checkAndUpdate(context, library);
            }
        }
    }

    private void downloadLibrary(CombinedDownloadContext<?> context, Library library, boolean fatal) throws InterruptedException {
        context.submit(this.provider.library(this.mcdir, library), null, fatal);
    }

    private boolean needDownload(File target, DownloadInfo info) throws NoSuchAlgorithmException, IOException {
        if (info == null) {
            return !target.isFile();
        }
        return !ChecksumUtils.verify(target, info.getChecksum(), "SHA-1", info.getSize());
    }

    private void checkAndUpdate(final CombinedDownloadContext<?> context, final Library lib) throws InterruptedException {
        if (this.updateSnapshots && lib.isSnapshotArtifact()) {
            final Library sha1lib = new Library(lib.getGroupId(), lib.getArtifactId(), lib.getVersion(), lib.getClassifier(), "jar.sha1");
            context.submit(this.provider.library(this.mcdir, sha1lib), new CallbackAdapter<Void>(){

                @Override
                public void done(Void result) {
                    try {
                        context.submit(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                String sha1 = IOUtils.toString(IncrementallyDownloadTask.this.mcdir.getLibrary(sha1lib)).trim();
                                if (!ChecksumUtils.verify(IncrementallyDownloadTask.this.mcdir.getLibrary(lib), sha1, "SHA-1")) {
                                    IncrementallyDownloadTask.this.downloadLibrary(context, lib, false);
                                }
                                return null;
                            }
                        }, null, false);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }, false);
        }
    }
}

