/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.launch;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.to2mbn.jmccc.launch.ProcessListener;
import org.to2mbn.jmccc.util.Platform;

class StreamLogger
implements Runnable {
    private ProcessListener listener;
    private boolean isErr;
    private InputStream in;

    public StreamLogger(ProcessListener listener, boolean isErr, InputStream in) {
        this.listener = listener;
        this.isErr = isErr;
        this.in = in;
    }

    @Override
    public void run() {
        char[] eol = Platform.getLineSeparator().toCharArray();
        try {
            int ch;
            InputStreamReader reader = new InputStreamReader(this.in, Platform.getEncoding());
            StringBuilder buffer = new StringBuilder();
            while ((ch = ((Reader)reader).read()) != -1) {
                buffer.append((char)ch);
                if (buffer.length() >= eol.length) {
                    boolean isEOL = true;
                    for (int i = 0; i < eol.length; ++i) {
                        if (eol[i] == buffer.charAt(buffer.length() - eol.length + i)) continue;
                        isEOL = false;
                        break;
                    }
                    if (isEOL) {
                        buffer.delete(buffer.length() - eol.length, buffer.length());
                        String log = buffer.toString();
                        buffer.delete(0, buffer.length());
                        if (this.isErr) {
                            this.listener.onErrorLog(log);
                        } else {
                            this.listener.onLog(log);
                        }
                    }
                }
                if (!Thread.interrupted()) continue;
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

