/*
 * Decompiled with CFR 0.152.
 */
package org.to2mbn.jmccc.launch;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.to2mbn.jmccc.auth.AuthInfo;
import org.to2mbn.jmccc.internal.org.json.JSONObject;
import org.to2mbn.jmccc.launch.ExitWaiter;
import org.to2mbn.jmccc.launch.LaunchArgument;
import org.to2mbn.jmccc.launch.LaunchException;
import org.to2mbn.jmccc.launch.Launcher;
import org.to2mbn.jmccc.launch.MissingDependenciesException;
import org.to2mbn.jmccc.launch.ProcessListener;
import org.to2mbn.jmccc.launch.StreamLogger;
import org.to2mbn.jmccc.launch.StreamPump;
import org.to2mbn.jmccc.option.LaunchOption;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.option.WindowSize;
import org.to2mbn.jmccc.util.FileUtils;
import org.to2mbn.jmccc.util.Platform;
import org.to2mbn.jmccc.util.UUIDUtils;
import org.to2mbn.jmccc.version.Asset;
import org.to2mbn.jmccc.version.Library;
import org.to2mbn.jmccc.version.Native;
import org.to2mbn.jmccc.version.Version;
import org.to2mbn.jmccc.version.parsing.Versions;

class LauncherImpl
implements Launcher {
    private boolean nativeFastCheck = false;
    private boolean printDebugCommandline = false;
    private boolean useDaemonThreads = false;

    @Override
    public Process launch(LaunchOption option) throws LaunchException {
        return this.launch(option, null);
    }

    @Override
    public Process launch(LaunchOption option, ProcessListener listener) throws LaunchException {
        return this.launch(this.generateLaunchArgs(option), listener);
    }

    public void setNativeFastCheck(boolean nativeFastCheck) {
        this.nativeFastCheck = nativeFastCheck;
    }

    public void setPrintDebugCommandline(boolean printDebugCommandline) {
        this.printDebugCommandline = printDebugCommandline;
    }

    public void setUseDaemonThreads(boolean useDaemonThreads) {
        this.useDaemonThreads = useDaemonThreads;
    }

    private Process launch(LaunchArgument arg, ProcessListener listener) throws LaunchException {
        Process process;
        String[] commandline = arg.generateCommandline();
        if (this.printDebugCommandline) {
            this.printDebugCommandline(commandline);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commandline);
        processBuilder.directory(arg.getLaunchOption().getRuntimeDirectory().getRoot());
        try {
            process = processBuilder.start();
        }
        catch (IOException | SecurityException e) {
            throw new LaunchException("Couldn't start process", e);
        }
        if (listener == null) {
            this.startStreamPumps(process);
        } else {
            this.startStreamLoggers(process, listener, this.useDaemonThreads);
        }
        return process;
    }

    public LaunchArgument generateLaunchArgs(LaunchOption option) throws LaunchException {
        WindowSize windowSize;
        Objects.requireNonNull(option);
        if (option.getJavaEnvironment() == null) {
            throw new IllegalArgumentException("No JavaEnvironment is specified");
        }
        MinecraftDirectory mcdir = option.getMinecraftDirectory();
        Version version = option.getVersion();
        Set<Library> missing = version.getMissingLibraries(mcdir);
        if (!missing.isEmpty()) {
            throw new MissingDependenciesException(missing);
        }
        LinkedHashSet<File> javaLibraries = new LinkedHashSet<File>();
        File nativesDir = mcdir.getNatives(version);
        for (Library library : version.getLibraries()) {
            File libraryFile = mcdir.getLibrary(library);
            if (library instanceof Native) {
                try {
                    this.decompressZipWithExcludes(libraryFile, nativesDir, ((Native)library).getExtractExcludes());
                    continue;
                }
                catch (IOException e) {
                    throw new LaunchException("Couldn't uncompress " + libraryFile, e);
                }
            }
            javaLibraries.add(libraryFile);
        }
        javaLibraries.add(mcdir.getVersionJar(version));
        javaLibraries.addAll(option.extraClasspath());
        if (version.isLegacy()) {
            try {
                this.buildLegacyAssets(mcdir, version);
            }
            catch (IOException e) {
                throw new LaunchException("Couldn't build virtual assets", e);
            }
        }
        AuthInfo auth = option.getAuthenticator().auth();
        HashMap<String, String> tokens = new HashMap<String, String>();
        String token = auth.getToken();
        String assetsDir = (version.isLegacy() ? mcdir.getVirtualLegacyAssets() : mcdir.getAssets()).getAbsolutePath();
        tokens.put("assets_root", assetsDir);
        tokens.put("game_assets", assetsDir);
        tokens.put("auth_access_token", token);
        tokens.put("auth_session", token);
        tokens.put("auth_player_name", auth.getUsername());
        tokens.put("auth_uuid", UUIDUtils.unsign(auth.getUUID()));
        tokens.put("user_type", auth.getUserType());
        tokens.put("user_properties", new JSONObject(auth.getProperties()).toString());
        tokens.put("version_name", version.getVersion());
        tokens.put("assets_index_name", version.getAssets());
        tokens.put("game_directory", option.getRuntimeDirectory().getAbsolutePath());
        tokens.put("natives_directory", nativesDir.getAbsolutePath());
        tokens.put("library_directory", mcdir.getLibraries().getAbsolutePath());
        tokens.put("classpath_separator", Platform.getPathSeparator());
        tokens.put("auth_xuid", auth.getXboxUserId());
        String type = version.getType();
        if (type != null) {
            tokens.put("version_type", type);
        }
        if ((windowSize = option.getWindowSize()) != null) {
            tokens.put("resolution_width", Integer.toString(windowSize.getWidth()));
            tokens.put("resolution_height", Integer.toString(windowSize.getHeight()));
        }
        return new LaunchArgument(option, tokens, javaLibraries, nativesDir);
    }

    private void buildLegacyAssets(MinecraftDirectory mcdir, Version version) throws IOException {
        Set<Asset> assets = Versions.resolveAssets(mcdir, version);
        if (assets != null) {
            for (Asset asset : assets) {
                FileUtils.copyFile(mcdir.getAsset(asset), mcdir.getVirtualAsset(asset));
            }
        }
    }

    private void decompressZipWithExcludes(File zip, File outputDir, Set<String> excludes) throws IOException {
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        try (ZipInputStream in = new ZipInputStream(Files.newInputStream(zip.toPath(), new OpenOption[0]));){
            ZipEntry entry;
            byte[] buf = null;
            while ((entry = in.getNextEntry()) != null) {
                boolean excluded = false;
                if (excludes != null) {
                    for (String exclude : excludes) {
                        if (!entry.getName().startsWith(exclude)) continue;
                        excluded = true;
                        break;
                    }
                }
                if (!excluded) {
                    boolean match;
                    int read;
                    if (buf == null || (long)buf.length < entry.getSize() - 1L) {
                        buf = new byte[(int)entry.getSize() + 1];
                    }
                    int len = 0;
                    while ((read = in.read(buf, len, buf.length - len)) != -1) {
                        if (read == 0) {
                            throw new IOException("actual length and entry length mismatch");
                        }
                        len += read;
                    }
                    File outFile = new File(outputDir, entry.getName());
                    if (outFile.isFile() && outFile.length() == entry.getSize()) {
                        match = true;
                        if (!this.nativeFastCheck) {
                            try (BufferedInputStream targetin = new BufferedInputStream(Files.newInputStream(outFile.toPath(), new OpenOption[0]));){
                                for (int i = 0; i < len; ++i) {
                                    if (buf[i] == (byte)((InputStream)targetin).read()) continue;
                                    match = false;
                                }
                            }
                        }
                    } else {
                        match = false;
                    }
                    if (!match) {
                        if (entry.isDirectory()) {
                            outFile.mkdir();
                        } else {
                            try (OutputStream out = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);){
                                out.write(buf, 0, len);
                            }
                        }
                    }
                }
                in.closeEntry();
            }
        }
    }

    private void printDebugCommandline(String[] commandline) {
        StringBuilder sb = new StringBuilder();
        sb.append("jmccc:\n");
        for (String arg : commandline) {
            sb.append(arg).append('\n');
        }
        System.err.println(sb);
    }

    private void startStreamPumps(Process process) {
        this.startThread("stdout-pump", true, new StreamPump(process.getInputStream()));
        this.startThread("stderr-pump", true, new StreamPump(process.getErrorStream()));
    }

    private void startStreamLoggers(Process process, ProcessListener listener, boolean daemon) {
        this.startThread("stdout-logger", daemon, new StreamLogger(listener, false, process.getInputStream()));
        this.startThread("stderr-logger", daemon, new StreamLogger(listener, true, process.getErrorStream()));
        this.startThread("exit-waiter", daemon, new ExitWaiter(process, listener));
    }

    private void startThread(String name, boolean daemon, Runnable runnable) {
        Thread t = new Thread(runnable);
        t.setName(name);
        t.setDaemon(daemon);
        t.start();
    }
}

